/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.TreeSet;
import org.jwall.web.audit.io.FileHandler;
import org.jwall.web.audit.io.LineReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialFileReader
implements LineReader {
    static Logger log = LoggerFactory.getLogger(SequentialFileReader.class);
    Integer sleep = 1000;
    File file = null;
    File current = null;
    Long currentOffset = 0L;
    File next = null;
    BufferedReader reader;
    boolean removeAfterRead = true;
    Long startTime = 0L;
    boolean running = true;
    Long toSkip = 0L;
    FileHandler oldFileHandler = null;

    public SequentialFileReader(File file) throws IOException {
        this(file, 0L, false);
    }

    public SequentialFileReader(File file, long start, boolean removeAfterRead) throws IOException {
        this.current = this.file = file;
        this.startTime = start;
        this.removeAfterRead = removeAfterRead;
        if (removeAfterRead) {
            this.oldFileHandler = new FileHandler(){

                @Override
                public void handle(File file) throws Exception {
                    file.delete();
                }
            };
        }
    }

    public File getCurrentFile() {
        return this.current;
    }

    public Long getCurrentOffset() {
        return this.currentOffset;
    }

    public FileHandler getOldFileHandler() {
        return this.oldFileHandler;
    }

    public void setOldFileHandler(FileHandler oldFileHandler) {
        this.oldFileHandler = oldFileHandler;
    }

    public boolean matchesSequence(File f) {
        if (log.isTraceEnabled()) {
            log.trace("checking file {}", (Object)f);
            log.trace("   start-time: {}", (Object)this.startTime);
            log.trace("   f.last-mod: {}  ({})", (Object)f.lastModified(), (Object)new Date(f.lastModified()));
        }
        if (f.isFile() && (f.equals(this.file) || f.getName().matches(String.valueOf(this.file.getName()) + "(\\.\\d+)?"))) {
            if (this.reader == null || f.lastModified() > this.current.lastModified()) {
                return true;
            }
            log.debug("Current file {} is still newer than {}", (Object)this.current, (Object)f);
        }
        return false;
    }

    public boolean hasNext() {
        File dir = this.file.getParentFile();
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (this.matchesSequence(f)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void openNextFile() throws IOException {
        log.debug("Current file {} seems to have ended, checking for next one", (Object)this.current);
        boolean proceeded = false;
        do {
            TreeSet<File> files = new TreeSet<File>();
            File dir = this.file.getParentFile();
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (this.matchesSequence(f) && this.startTime <= f.lastModified()) {
                    log.debug("  File {}  (last-modified-at {}) is considered a candidate to proceed", (Object)f, (Object)f.lastModified());
                    if (this.startTime <= f.lastModified()) {
                        files.add(f);
                    } else {
                        log.debug("Skipping file {} which has modification " + f.lastModified() + " time BEFORE offset-time ({})", (Object)f, (Object)this.startTime);
                    }
                }
                ++n2;
            }
            TreeSet<File> sequence = files;
            log.debug("candidate files: {}", sequence);
            if (!sequence.isEmpty()) {
                if (this.reader != null) {
                    log.debug("Closing old reader...");
                    this.reader.close();
                }
                try {
                    if (this.oldFileHandler != null) {
                        this.oldFileHandler.handle(this.current);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.current = (File)sequence.first();
                this.startTime = this.current.lastModified();
                this.currentOffset = 0L;
                this.reader = new BufferedReader(new FileReader(this.current));
                if (this.toSkip > 0L) {
                    log.debug("Skipping {} bytes", (Object)this.toSkip);
                    Long skipped = this.reader.skip(this.toSkip);
                    this.toSkip = 0L;
                    this.currentOffset = this.currentOffset + skipped;
                }
                proceeded = true;
            } else {
                if (!this.running) {
                    log.trace("file-reader closed, returning!");
                    return;
                }
                log.debug("sequential reader running? {}", (Object)this.running);
                try {
                    log.debug("No sequential file found for {}, sleeping for {} ms and checking again...", (Object)this.file, (Object)this.sleep);
                    Thread.sleep(this.sleep.intValue());
                }
                catch (Exception e) {
                    log.debug("seq-file-reader running? {}", (Object)this.running);
                    e.printStackTrace();
                }
            }
            if (this.running) continue;
            return;
        } while (this.running && !proceeded);
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized String readLine() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getSource() {
        return "" + this.current;
    }

    @Override
    public void skip(Long bytes) {
        block4: {
            try {
                if (this.reader != null) {
                    Long skipped = this.reader.skip(bytes);
                    this.currentOffset = this.currentOffset + skipped;
                } else {
                    this.toSkip = bytes;
                }
            }
            catch (Exception e) {
                log.error("Failed to skip {} bytes: {}", (Object)bytes, (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block4;
                e.printStackTrace();
            }
        }
    }

    @Override
    public Long bytesRead() {
        return this.getCurrentOffset();
    }

    public void close() {
        log.trace("Closing sequential-file-reader");
        this.running = false;
    }
}

