/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.AuditEventType;
import org.jwall.web.audit.io.AbstractAuditEventReader;
import org.jwall.web.audit.io.AuditEventIterator;
import org.jwall.web.audit.io.AuditEventReader;
import org.jwall.web.audit.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModSecurity2AuditStream
extends AbstractAuditEventReader
implements AuditEventReader,
Runnable {
    static Logger log = LoggerFactory.getLogger((String)"ModSecurity2AuditReader");
    boolean tail;
    AuditEventListener listener;

    public ModSecurity2AuditStream(InputStream in, AuditEventListener listener) throws IOException {
        this(in, listener, true);
    }

    public ModSecurity2AuditStream(InputStream in, AuditEventListener listener, boolean persist) throws IOException {
        super(in);
        this.listener = listener;
        this.tail = persist;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AuditEvent readNext() throws IOException, ParseException {
        log.info("readEvent " + this.counter);
        ++this.counter;
        String line = "";
        long offset = (long)this.getDataRead();
        try {
            this.reader.mark(0x100000);
        }
        catch (Exception e) {
            log.error("Failed to set marker at offset {}: {}", (Object)offset, (Object)e);
            return null;
        }
        StringBuffer[] sections = new StringBuffer["ABCDEFGHIJKTXZ".length()];
        int i = 0;
        while (i < sections.length) {
            sections[i] = new StringBuffer();
            ++i;
        }
        int ptr = 0;
        try {
            while (this.reader.ready() && !line.matches("--[\\-\\@0-9A-Za-z]*-A--")) {
                try {
                    line = this.reader.readLine();
                }
                catch (EOFException eof) {
                    boolean bl = this.eofReached = !this.tail;
                }
                if (line == null) {
                    this.reader.reset();
                    return null;
                }
                this.bytesRead += (double)line.length() + 1.0;
            }
            String id = line.replaceFirst("--", "").replaceAll("-A--", "");
            while (!line.startsWith("--") || !line.endsWith("-Z--")) {
                log.info("line: {}", (Object)line);
                ptr = ModSecurity2AuditStream.getSectionIndex(line);
                while (!this.reader.ready()) {
                    this.wait();
                }
                line = this.reader.readLine();
                if (line == null) {
                    if (!this.reader.markSupported()) return null;
                    this.reader.reset();
                    return null;
                }
                this.bytesRead += (double)line.length() + 1.0;
                if (ptr < 0) {
                    log.debug("Line contains invalid section-name: " + line);
                    continue;
                }
                sections[ptr] = new StringBuffer();
                do {
                    sections[ptr].append(String.valueOf(line) + "\n");
                    line = this.reader.readLine();
                    if (line == null) {
                        this.reader.reset();
                        return null;
                    }
                    this.bytesRead += (double)line.length();
                    log.info("line: {}", (Object)line);
                } while (!line.trim().matches("^--.*-[A-Z]--$"));
            }
            String[] data = new String["ABCDEFGHIJKTXZ".length()];
            int i2 = 0;
            while (i2 < data.length) {
                data[i2] = sections[i2].toString();
                ++i2;
            }
            if (!data[0].equals("")) return this.eventFactory.createAuditEvent(id, data, this.inputFile, offset, (long)this.bytesRead - offset, AuditEventType.ModSecurity2);
            return null;
        }
        catch (EOFException eof) {
            this.eofReached = true;
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String readline() throws IOException {
        StringBuffer s = new StringBuffer();
        while (this.reader.ready()) {
            int c = this.reader.read();
            if (c == 19) continue;
            s.append(c);
        }
        return null;
    }

    @Override
    public void run() {
        try {
            while (true) {
                AuditEvent event = this.readNext();
                this.listener.eventArrived(event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
            return;
        }
    }

    @Override
    public Iterator<AuditEvent> iterator() {
        try {
            return new AuditEventIterator(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

