/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import org.jwall.web.audit.AuditEventMessage;
import org.jwall.web.audit.IronBeeEventMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;

public class IronBeeJSONProcessor
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(IronBeeJSONProcessor.class);
    String[] keys = new String[]{"events", "http-request-metadata", "http-response-metadata"};

    public Data process(Data data) {
        String[] stringArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            String section = stringArray[n2];
            Serializable content = (Serializable)data.get((Object)section);
            String contentType = "";
            try {
                BufferedReader reader = new BufferedReader(new StringReader(content.toString()));
                String line = reader.readLine();
                while (line != null && !line.trim().isEmpty()) {
                    if (line.toLowerCase().startsWith("content-type: ")) {
                        contentType = line.substring("content-type: ".length());
                    }
                    line = reader.readLine();
                }
                if ("application/json".equalsIgnoreCase(contentType)) {
                    log.debug("Handling JSON content, parts is named {}");
                    JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
                    JSONObject object = (JSONObject)p.parse((Reader)reader, JSONObject.class);
                    log.debug("object: {}", (Object)object);
                    if (object instanceof Map) {
                        for (String key : object.keySet()) {
                            if (key.equalsIgnoreCase("events")) {
                                JSONArray evts = (JSONArray)object.get((Object)key);
                                AuditEventMessage[] msgs = new AuditEventMessage[evts.size()];
                                int i = 0;
                                while (i < evts.size()) {
                                    IronBeeEventMessage ib = new IronBeeEventMessage();
                                    log.debug("events[{}] = {}", (Object)i, evts.get(i));
                                    JSONObject event = (JSONObject)evts.get(i);
                                    log.debug("  message: {}", (Object)event);
                                    for (String k : event.keySet()) {
                                        log.debug("     message[{}] = {}", (Object)k, event.get((Object)k));
                                        Object obj = event.get((Object)k);
                                        if (obj instanceof JSONArray) {
                                            JSONArray arr = (JSONArray)obj;
                                            String[] d = new String[arr.size()];
                                            int idx = 0;
                                            while (idx < arr.size()) {
                                                d[idx] = arr.get(idx).toString();
                                                ++idx;
                                            }
                                            log.debug("Setting {} = {}", (Object)k, (Object)d);
                                            ib.set(k, (Serializable)d);
                                            continue;
                                        }
                                        ib.set(k, (Serializable)((Object)event.get((Object)k).toString()));
                                    }
                                    msgs[i] = ib;
                                    ++i;
                                }
                                data.put((Object)"event_messages", (Object)msgs);
                                continue;
                            }
                            log.debug("Processing section {}", (Object)key);
                            Object value = object.get((Object)key);
                            if (value instanceof Serializable) {
                                data.put((Object)key, (Object)((Serializable)value));
                                continue;
                            }
                            data.put((Object)key, (Object)object.get((Object)key).toString());
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("Failed to parse JSON data in section '{}': {}", (Object)section, (Object)e.getMessage());
            }
            ++n2;
        }
        return data;
    }
}

