/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.IronBeeAuditEvent;
import org.jwall.web.audit.io.AuditEventReader;
import org.jwall.web.audit.io.IronBeeHttpHeaderParser;
import org.jwall.web.audit.io.IronBeeJSONProcessor;
import org.jwall.web.audit.io.ParseException;
import org.jwall.web.audit.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.ProcessContext;
import stream.Processor;
import stream.StatefulProcessor;
import stream.data.DataFactory;
import stream.runtime.ProcessContextImpl;

public class IronBeeAuditReader
implements AuditEventReader {
    static Logger log = LoggerFactory.getLogger(IronBeeAuditReader.class);
    BufferedInputStream inputStream;
    final IBEventHandler handler = new IBEventHandler();
    final MimeStreamParser stream = new MimeStreamParser();
    List<Processor> processors = new ArrayList<Processor>();

    public IronBeeAuditReader(InputStream in) throws IOException {
        this.inputStream = new BufferedInputStream(in);
        this.processors.add(new IronBeeHttpHeaderParser("http-request-headers", "HTTP_REQUEST_HEADERS", "REQUEST_LINE"));
        this.processors.add(new IronBeeHttpHeaderParser("http-response-headers", "HTTP_RESPONSE_HEADERS", "RESPONSE_LINE"));
        this.processors.add((Processor)new IronBeeJSONProcessor());
        this.processors.add((Processor)new Timestamp("DATE", "yyyy-mm-dd'T'hh:mm:ss.SZ", "REQUEST_TIMESTAMP"));
        this.processors.add((Processor)new Timestamp("RECEIVED", "yyyy-mm-dd'T'hh:mm:ss.SZ", "LOG_TIMESTAMP"));
        ProcessContextImpl ctx = new ProcessContextImpl();
        for (Processor p : this.processors) {
            try {
                if (!(p instanceof StatefulProcessor)) continue;
                ((StatefulProcessor)p).init((ProcessContext)ctx);
            }
            catch (Exception e) {
                throw new IOException("Failed to initialize processor for IronBeeAuditReader: " + e.getMessage());
            }
        }
        this.stream.setContentHandler((ContentHandler)this.handler);
    }

    @Override
    public Iterator<AuditEvent> iterator() {
        return null;
    }

    @Override
    public AuditEvent readNext() throws IOException, ParseException {
        try {
            this.handler.reset();
            this.stream.parse((InputStream)this.inputStream);
            Data data = this.handler.getItem();
            for (Processor p : this.processors) {
                data = p.process(data);
            }
            log.debug("Data parsed is:\n{}", (Object)data);
            data.put((Object)"__SECTION_BOUNDARY_KEY__", (Object)this.handler.boundary);
            return new IronBeeAuditEvent(data);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public boolean atEOF() {
        return false;
    }

    @Override
    public long bytesRead() {
        return 0L;
    }

    @Override
    public long bytesAvailable() {
        return 0L;
    }

    public class IBEventHandler
    implements ContentHandler {
        Logger log = LoggerFactory.getLogger(IBEventHandler.class);
        String name = null;
        Data item = DataFactory.create();
        String boundary = "";
        Map<String, String> sections = new LinkedHashMap<String, String>();
        StringBuffer currentSection = new StringBuffer();

        public void reset() {
            this.item = DataFactory.create();
        }

        public void startMessage() throws MimeException {
            this.log.debug("startMessage()");
        }

        public void endMessage() throws MimeException {
            this.log.debug("endMessage()");
        }

        public void startBodyPart() throws MimeException {
            this.log.debug("startBodyPart()");
        }

        public void endBodyPart() throws MimeException {
            this.log.debug("endBodyPart()");
            if (this.name != null) {
                this.sections.put(this.name, this.currentSection.toString());
            }
        }

        public void startHeader() throws MimeException {
            this.log.debug("startHeader()");
            this.name = null;
            this.currentSection = new StringBuffer();
        }

        public void field(Field rawField) throws MimeException {
            int idx;
            int end;
            String line;
            int idx2;
            this.log.debug("field( {} )", (Object)rawField);
            this.currentSection.append(String.valueOf(rawField.getName()) + ": " + rawField.getBody());
            this.currentSection.append("\r\n");
            if ("Content-Disposition".equals(rawField.getName()) && (idx2 = (line = rawField.getBody()).indexOf("name=\"")) > 0 && (end = line.indexOf("\"", idx2 += "name=\"".length())) > 0) {
                this.name = line.substring(idx2, end);
                this.log.debug("Diving into section '{}'", (Object)this.name);
            }
            if ("Content-Type".equals(rawField.getName()) && (idx = rawField.getBody().indexOf("boundary=")) > 0) {
                this.boundary = rawField.getBody().substring(idx + "boundary=".length());
                this.log.debug("Boundary is '{}'", (Object)this.boundary);
            }
        }

        public void endHeader() throws MimeException {
            this.log.debug("endHeader()");
            this.currentSection.append("\r\n");
        }

        public void preamble(InputStream is) throws MimeException, IOException {
            this.log.debug("preamble(...)");
        }

        public void epilogue(InputStream is) throws MimeException, IOException {
            this.log.debug("epilogue(...)");
        }

        public void startMultipart(BodyDescriptor bd) throws MimeException {
            this.log.debug("startMultiPart( {} )", (Object)bd);
        }

        public void endMultipart() throws MimeException {
            this.log.debug("endMultiPart()");
        }

        public void body(BodyDescriptor bd, InputStream is) throws MimeException, IOException {
            if (this.name == null) {
                this.log.warn("No section name found, skipping section!");
            }
            this.log.debug("section: '{}'", (Object)this.name);
            this.log.debug("body( {} )", (Object)bd);
            this.log.debug("subType: {}", (Object)bd.getSubType());
            this.log.debug("body-length is {} bytes", (Object)bd.getContentLength());
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            while (line != null) {
                this.currentSection.append(String.valueOf(line) + "\r\n");
                line = reader.readLine();
            }
            this.item.put((Object)("SECTION:" + this.name), (Object)this.currentSection.toString());
            StringBuffer s = new StringBuffer();
            BufferedReader r = new BufferedReader(new StringReader(this.currentSection.toString()));
            line = r.readLine();
            while (line != null) {
                s.append(String.valueOf(line) + "\r\n");
                this.log.debug("   body.line: {}", (Object)line);
                line = r.readLine();
            }
            r.close();
            this.log.debug("/body()");
        }

        public void raw(InputStream is) throws MimeException, IOException {
            this.log.debug("raw( ... )");
        }

        public Data getItem() {
            for (String sect : this.sections.keySet()) {
                this.item.put((Object)sect, (Object)((Serializable)((Object)this.sections.get(sect))));
            }
            return this.item;
        }
    }
}

