/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.io.AbstractAuditEventReader;
import org.jwall.web.audit.io.AccessLogAuditReader;
import org.jwall.web.audit.io.AuditEventIterator;
import org.jwall.web.audit.io.ModSecurity2AuditReader;
import org.jwall.web.audit.io.ParseException;
import org.jwall.web.audit.util.ParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentAuditReader
extends AbstractAuditEventReader {
    private static Logger log = LoggerFactory.getLogger(ConcurrentAuditReader.class);
    private File index;
    private File dataDir;
    private boolean finished = false;
    private long bytesRead = 0L;
    private boolean tail = true;

    public ConcurrentAuditReader(File dataDir, File indexFile, boolean tail) throws IOException {
        super(new FileInputStream(indexFile));
        this.dataDir = dataDir;
        this.tail = tail;
        this.index = indexFile;
        if (!this.index.exists() || !this.index.canRead()) {
            throw new IOException("Cannot read index-file: " + this.index.toString());
        }
        if (tail) {
            log.debug("Listening on tail of index-file (skipping " + this.index.length() + " bytes)...");
            this.reader.skip(this.index.length());
        } else {
            log.debug("Reading complete index-file...");
        }
    }

    public ConcurrentAuditReader(InputStream index, File dataDir) throws IOException {
        super(index);
        this.dataDir = dataDir;
        log.debug("Listening on tail of index-file...");
    }

    public ConcurrentAuditReader(File data, File index) throws IOException {
        this(data, index, false);
    }

    public ConcurrentAuditReader(File dataDir, boolean tail) throws IOException {
        this(dataDir, new File(String.valueOf(dataDir.getAbsolutePath()) + "/index"), tail);
    }

    public ConcurrentAuditReader(File dataDir) throws IOException {
        this(dataDir, false);
    }

    @Override
    public AuditEvent readNext() throws IOException, ParseException {
        log.debug("ConcurrentAuditReader.readNext()");
        String line = null;
        do {
            line = this.reader.readLine();
            while (line == null && this.tail) {
                try {
                    log.debug("Waiting for next event...");
                    Thread.sleep(1000L);
                    line = this.reader.readLine();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            log.debug("line: " + line);
            if (line == null) {
                this.eofReached = true;
                if (this.tail) {
                    return null;
                }
            } else {
                return this.readEvent(line);
            }
            log.debug("End-of-file reached, not in \"continuous-reading\"-mode. Closing.");
            this.finished = true;
        } while (!this.finished);
        log.debug("index-line: " + line);
        return null;
    }

    public AuditEvent readEvent(String s) throws IOException, ParseException {
        String line = s.replaceFirst("\\[", "\"").replaceFirst("\\]", "\"");
        String[] token = ParserUtils.splitQuotedString(line);
        token = AccessLogAuditReader.splitAccessLine(line);
        File evtFile = new File(String.valueOf(this.dataDir.getAbsolutePath()) + "/" + token[12]);
        log.debug("Reading event from " + evtFile.getAbsoluteFile());
        int retries = 3;
        while (!(retries <= 0 || evtFile.exists() && evtFile.canRead())) {
            try {
                log.debug("waiting for file {} to be created...", (Object)evtFile.getAbsolutePath());
                --retries;
                Thread.sleep(200L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        if (!evtFile.exists()) {
            throw new IOException("File not found: " + evtFile.getAbsolutePath());
        }
        if (!evtFile.canRead()) {
            throw new IOException("Cannot read event from file: " + evtFile.getAbsolutePath());
        }
        try {
            ModSecurity2AuditReader ms2ar = new ModSecurity2AuditReader(evtFile);
            AuditEvent evt = ((AbstractAuditEventReader)ms2ar).readNext();
            ms2ar.close();
            return evt;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void finish() {
        this.finished = true;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public long bytesRead() {
        return this.bytesRead;
    }

    @Override
    public long bytesAvailable() {
        if (this.index != null) {
            return this.index.length();
        }
        return Long.MAX_VALUE;
    }

    @Override
    public Iterator<AuditEvent> iterator() {
        try {
            return new AuditEventIterator(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

