/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.filter;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.jwall.audit.Match;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.filter.AuditEventFilter;
import org.jwall.web.audit.filter.FilterExpression;
import org.jwall.web.audit.filter.Operator;
import org.jwall.web.audit.rules.operators.AbstractCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="AuditEventMatch")
public class AuditEventMatch
extends Match
implements FilterExpression {
    private static final long serialVersionUID = -3682911278800228726L;
    static Logger log = LoggerFactory.getLogger(AuditEventMatch.class);

    public AuditEventMatch() {
    }

    public AuditEventMatch(String variable) {
        super(variable);
    }

    public AuditEventMatch(String variable, String value) {
        this(variable, Operator.EQ, value);
    }

    public AuditEventMatch(String variable, Operator op, String value) {
        super(variable, op, value);
    }

    @Override
    public boolean matches(AuditEvent evt) {
        if (log.isDebugEnabled()) {
            log.debug("Matching event {}", (Object)evt.getEventId());
        }
        if (evt == null) {
            return false;
        }
        if (this.condition == null && this.getValue() != null) {
            try {
                this.condition = AbstractCondition.createCondition(this.getOp(), this.getVariable(), this.getValue());
            }
            catch (Exception e) {
                log.error("Failed to create condition for op: {}", (Object)this.getOperator());
                return false;
            }
        }
        return this.condition.matches(evt);
    }

    @Override
    public String toXML() {
        return AuditEventFilter.getXStream().toXML((Object)this);
    }

    public Object readResolve() {
        try {
            this.condition = AbstractCondition.createCondition(this.getOp(), this.getVariable(), this.getValue());
        }
        catch (Exception e) {
            log.error("Variable: {}", (Object)this.getVariable());
            log.error("Operator: {}", (Object)this.getOp());
            log.error("Value: {}", (Object)this.getValue());
            log.error("Error: {}", (Object)e.getMessage());
            e.printStackTrace();
            this.condition = null;
        }
        return this;
    }
}

