/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.filter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.jwall.audit.Match;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.filter.AuditEventMatch;
import org.jwall.web.audit.filter.FilterExpression;

@XStreamAlias(value="Filter")
public class AuditEventFilter
implements Serializable,
FilterExpression {
    private static final long serialVersionUID = 7710316960125556052L;
    @XStreamImplicit
    LinkedList<AuditEventMatch> matches = new LinkedList();
    @XStreamAlias(value="enabled")
    @XStreamAsAttribute
    boolean enabled = true;

    public List<AuditEventMatch> getMatches() {
        if (this.matches == null) {
            this.matches = new LinkedList();
        }
        return this.matches;
    }

    public void add(Match m) {
        this.add(new AuditEventMatch(m.getVariable(), m.getOp(), m.getValue()));
    }

    public void add(AuditEventMatch match) {
        this.matches.add(match);
    }

    public void remove(AuditEventMatch match) {
        this.matches.remove(match);
    }

    public boolean remove(int i) {
        try {
            this.matches.remove(i);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void removeMatch(String variable) {
        int idx = -1;
        for (AuditEventMatch m : this.matches) {
            if (!variable.equals(m.getVariable())) continue;
            idx = this.matches.indexOf(m);
            break;
        }
        if (idx >= 0) {
            this.matches.remove(idx);
        }
    }

    public boolean hasMatchOn(String variable) {
        for (AuditEventMatch m : this.matches) {
            if (!variable.equals(m.getVariable())) continue;
            return true;
        }
        return false;
    }

    public String toXML() {
        return AuditEventFilter.getXStream().toXML((Object)this);
    }

    public AuditEventFilter fromXML(String input) {
        return (AuditEventFilter)AuditEventFilter.getXStream().fromXML(input);
    }

    public static XStream getXStream(ClassLoader loader) {
        XStream xs = new XStream();
        xs.processAnnotations(AuditEventFilter.class);
        xs.processAnnotations(AuditEventMatch.class);
        return xs;
    }

    public static XStream getXStream() {
        return AuditEventFilter.getXStream(AuditEventFilter.class.getClassLoader());
    }

    @Override
    public boolean matches(AuditEvent evt) {
        if (this.matches == null) {
            return false;
        }
        for (AuditEventMatch m : this.matches) {
            if (m.matches(evt)) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }
}

