/*
 * Decompiled with CFR 0.152.
 */
package org.jwall;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Date;

@XStreamAlias(value="Version")
public class Version {
    String groupId;
    String artifactId;
    String version;
    String revision = "";
    String build = "";
    Date released;

    public Version(String ver, String rev, Date releaseDate) {
        this.version = ver;
        this.revision = rev;
        this.released = releaseDate;
    }

    public Version(String groupId, String artifactId, String ver, String rev, String build, Date releaseDate) {
        this(ver, rev, releaseDate);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.build = build;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public Date getReleased() {
        return this.released;
    }

    public void setReleased(Date released) {
        this.released = released;
    }

    public static final Version getVersion(String groupId, String artifactId) {
        String propertiesPath = "/" + artifactId + ".info";
        try {
            InputStream resourceStream = Version.class.getResourceAsStream(propertiesPath);
            if (resourceStream == null) {
                return new Version(groupId, artifactId, "?", "?", "", new Date());
            }
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(resourceStream));
            String versionString = "";
            String groupString = "";
            String artifactString = artifactId;
            String buildString = "";
            String line = reader.readLine();
            while (line != null) {
                if (!line.trim().startsWith("#")) {
                    String[] t = line.split("=", 2);
                    if (t[0].equals("version")) {
                        versionString = t[1].trim();
                    }
                    if (t[0].equals("groupId")) {
                        groupString = t[1].trim();
                    }
                    if (t[0].equals("artifactId")) {
                        artifactString = t[1].trim();
                    }
                    if (t[0].equals("build")) {
                        buildString = t[1].trim();
                    }
                }
                line = reader.readLine();
            }
            reader.close();
            return new Version(groupString, artifactString, versionString, "", buildString, new Date());
        }
        catch (Exception e) {
            System.err.println("can't load pom.properites => version information will be unavailable");
            return new Version(groupId, artifactId, "?", "?", "", new Date());
        }
    }

    public String toString() {
        String b = this.build;
        if (b != null) {
            b = b.replaceAll("\\D*", "");
        }
        StringBuffer s = new StringBuffer();
        if (this.groupId != null && !this.groupId.isEmpty()) {
            s.append(String.valueOf(this.groupId) + "/");
        }
        if (this.artifactId != null) {
            s.append(this.artifactId);
        }
        if (this.version != null && !this.version.trim().isEmpty()) {
            s.append("-" + this.version.trim());
        }
        if (b != null && !b.trim().isEmpty()) {
            s.append("-b" + b);
        }
        return s.toString();
    }

    public static String extractRevision(String revision) {
        int st = revision.indexOf(" ");
        if (st < 0) {
            return "";
        }
        int en = revision.indexOf(" ", st + 1);
        if (en < st) {
            return "";
        }
        String rev = revision.substring(st + 1, en);
        return rev;
    }

    public String getBuild() {
        return this.build;
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            System.out.println(Version.getVersion(args[0], args[1]));
        } else {
            System.out.println(Version.getVersion("org.jwall", "org.jwall.web.audit"));
        }
    }
}

