/*
 * Decompiled with CFR 0.152.
 */
package org.jwall;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.jwall.web.audit.AuditEventDispatcher;
import org.jwall.web.audit.ModSecurityAuditEvent;
import org.jwall.web.audit.io.AbstractAuditEventReader;
import org.jwall.web.audit.io.AccessLogAuditReader;
import org.jwall.web.audit.io.AuditFormat;
import org.jwall.web.audit.io.ConcurrentAuditReader;
import org.jwall.web.audit.io.ModSecurity2AuditReader;
import org.jwall.web.audit.io.ModSecurityAuditReader;
import org.jwall.web.audit.net.NetworkEventServer;
import org.jwall.web.audit.util.SimplePasswordAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditServer {
    public static final String VERSION = "v0.1";
    private static SimpleDateFormat LOG_DATE = ModSecurityAuditEvent.fmt;
    private static Logger log = LoggerFactory.getLogger((String)"AuditServer");

    public static void main(String[] args) {
        try {
            File auditFile = null;
            int port = 10001;
            long skip = 0L;
            SimplePasswordAuthenticator auth = null;
            if (args.length == 0) {
                AuditServer.printUsage();
                System.exit(-1);
            }
            int i = 0;
            while (i < args.length) {
                if (args[i].startsWith("-v") || args[i].startsWith("--v")) {
                    System.out.println("AuditServer, Version v0.1");
                    System.exit(0);
                }
                if (args[i].equals("-h") || args[i].startsWith("--h") || args[i].equals("-?")) {
                    AuditServer.printUsage();
                    System.exit(0);
                }
                if (!(!args[i].equals("--audit-file") || i + 1 >= args.length || (auditFile = new File(args[i + 1])).exists() && auditFile.canRead())) {
                    log.warn("Cannot read audit-data from: " + auditFile.getAbsolutePath());
                    System.exit(-1);
                }
                if ((args[i].startsWith("--server-port") || args[i].equals("--port")) && i + 1 < args.length) {
                    try {
                        port = Integer.parseInt(args[i + 1]);
                    }
                    catch (Exception e) {
                        log.warn("Invalid port: " + e.getMessage());
                        System.exit(-1);
                    }
                }
                if ((args[i].startsWith("--server-users") || args[i].startsWith("--users")) && i + 1 < args.length) {
                    try {
                        if (auth != null) {
                            throw new Exception("Authentication already specified!");
                        }
                        Properties users = new Properties();
                        users.load(new FileInputStream(new File(args[i + 1])));
                        Properties groups = new Properties();
                        log.info("Using file-authentication, " + users.keySet().size() + " users loaded.");
                        if (users.keySet().size() == 0) {
                            users.put("admin", "sercet");
                        }
                        auth = new SimplePasswordAuthenticator(users, groups);
                    }
                    catch (Exception pe) {
                        pe.printStackTrace();
                        log.warn("Could not read password-file for user authentication!");
                        System.exit(-1);
                    }
                }
                ++i;
            }
            if (auditFile == null) {
                log.warn("\nAn audit-file needs to be provided. Use:\n   --audit-file <file>\n");
                System.exit(-1);
            }
            if (auth == null) {
                log.warn("No authentication database specified, using password based auth with user \"admin\", password \"secret\"!");
                Properties users = new Properties();
                users.put("admin", "secret");
                auth = new SimplePasswordAuthenticator(users, new Properties());
            }
            skip = 1L;
            AbstractAuditEventReader r = null;
            int format = AuditFormat.guessFormat(auditFile);
            if (format == 0) {
                r = new AccessLogAuditReader(auditFile, skip > 0L);
            }
            if (format == 1) {
                r = new ModSecurityAuditReader(auditFile, skip > 0L);
            }
            if (format == 2) {
                r = new ModSecurity2AuditReader(auditFile, skip > 0L);
            }
            if (format == 3) {
                File dataDir = new File(auditFile.getParent());
                r = new ConcurrentAuditReader(auditFile, dataDir);
            }
            if (r == null) {
                log.warn("Could not create reader for the audit-log file on " + auditFile.getAbsolutePath());
                System.exit(-1);
            }
            NetworkEventServer server = null;
            try {
                InputStream kurl = AuditServer.class.getResourceAsStream("/org/jwall/web/audit/net/keystore");
                server = NetworkEventServer.createSSLEventServer(kurl, port, auth);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                System.exit(-1);
            }
            server.start();
            AuditEventDispatcher d = new AuditEventDispatcher(r);
            d.addAuditEventListener(server);
            d.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void daemonize() throws Exception {
        System.in.close();
        System.err.close();
        System.out.close();
    }

    public static void printUsage() {
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(AuditServer.class.getResourceAsStream("/org/jwall/server-usage.txt")));
            String line = null;
            do {
                if ((line = r.readLine()) == null) continue;
                System.out.println(line);
            } while (line != null);
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void log(String msg) {
        log.info("[" + LOG_DATE.format(new Date()) + "] org.jwall.AuditServer: " + msg);
    }
}

