/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.processor;

import java.util.Map;
import org.jwall.audit.EventProcessor;
import org.jwall.web.audit.AuditEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XForwardedForResolver
implements EventProcessor<AuditEvent> {
    static Logger log = LoggerFactory.getLogger(XForwardedForResolver.class);
    public static String X_FORWARDED_FOR = "REQUEST_HEADERS" + ":X-Forwarded-For".toUpperCase();

    @Override
    public AuditEvent processEvent(AuditEvent event, Map<String, Object> context) throws Exception {
        log.debug("Processing event '{}'", (Object)event.get("TX_ID"));
        String forwardedFor = event.get(X_FORWARDED_FOR);
        log.debug("  value for X-Forwarded-For is: {}", (Object)forwardedFor);
        if (forwardedFor != null && !forwardedFor.trim().equals("")) {
            int idx = forwardedFor.indexOf(",");
            if (idx > 0) {
                forwardedFor = forwardedFor.substring(0, idx).trim();
            }
            log.debug("Found X-Forwarded-For header, value: '{}'", (Object)forwardedFor.trim());
            event.set("REMOTE_ADDR", forwardedFor.trim());
        } else {
            log.debug("No X-Forwarded-For present in event '{}'", (Object)event.get("TX_ID"));
        }
        return event;
    }
}

