/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.net;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.AuditEventType;
import org.jwall.web.audit.io.AbstractAuditEventReader;
import org.jwall.web.audit.io.AuditEventIterator;
import org.jwall.web.audit.io.AuditEventReader;
import org.jwall.web.audit.io.LineReader;
import org.jwall.web.audit.io.ModSecurity2AuditReader;
import org.jwall.web.audit.io.ParseException;
import org.jwall.web.audit.io.SequentialFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogAuditEventStream
extends AbstractAuditEventReader
implements AuditEventReader,
Runnable {
    private static final String REGEX_EVENT_START = "--[\\-\\@0-9A-Za-z]*-A--";
    static Logger log = LoggerFactory.getLogger(ModSecurity2AuditReader.class);
    boolean tail;
    int lines = 0;
    String prefix = null;
    String sensor = "";
    AuditEventListener listener;
    boolean autoDetection = true;
    LineReader lineReader;

    public SyslogAuditEventStream(InputStream in, AuditEventListener listener) throws IOException {
        this(in, listener, true);
    }

    public SyslogAuditEventStream(InputStream in, AuditEventListener listener, boolean persist) throws IOException {
        super(in);
        this.listener = listener;
        this.tail = persist;
    }

    public SyslogAuditEventStream(FileReader reader, AuditEventListener listener, boolean tail) {
        super(reader);
        this.listener = listener;
        this.tail = tail;
    }

    public SyslogAuditEventStream(File file, AuditEventListener l) throws IOException {
        super(new ByteArrayInputStream(new byte[0]));
        this.listener = l;
        this.lineReader = new SequentialFileReader(file);
    }

    public SyslogAuditEventStream(File file, AuditEventListener l, boolean autoRemove) throws IOException {
        this(file, l);
        this.lineReader = new SequentialFileReader(file, 0L, autoRemove);
    }

    @Override
    public AuditEvent readNext() throws IOException, ParseException, EOFException {
        ++this.counter;
        String line = this.readLine();
        block3: while (this.autoDetection && line != null) {
            log.debug("auto-detection in progress, line is: '{}'", (Object)line);
            if (line.matches(REGEX_EVENT_START)) {
                this.autoDetection = false;
                this.prefix = "";
                break;
            }
            if (line.trim().endsWith("-A--")) {
                log.debug("Found start-of-event marker!");
                for (int i = line.length() - 1; i >= 0; --i) {
                    if (line.charAt(i) != ' ') continue;
                    int prioEnd = line.indexOf(">");
                    if (prioEnd > 1) {
                        log.debug("Priority: {}", (Object)line.substring(1, prioEnd));
                        Integer prio = new Integer(line.substring(1, prioEnd));
                        log.debug("Prio byte: {}", (Object)prio.byteValue());
                    }
                    log.debug("Prefix is: '{}'", (Object)line.substring(0, i + 1));
                    String[] tok = line.split(" ");
                    int len = tok.length;
                    log.debug("  marker: '{}'", (Object)tok[len - 1]);
                    log.debug("     tag: '{}'", (Object)tok[len - 2]);
                    log.debug("    host: '{}'", (Object)tok[len - 3]);
                    this.prefix = " " + tok[len - 3] + " " + tok[len - 2] + " ";
                    this.sensor = tok[len - 2].substring(0, tok[len - 2].length() - 1);
                    log.debug(" auto-detected prefix is: '{}', sensor is '{}'", (Object)this.prefix, (Object)this.sensor);
                    this.autoDetection = false;
                    line = this.chop(line);
                    continue block3;
                }
                continue;
            }
            line = this.readLine();
        }
        long offset = (long)this.getDataRead();
        StringBuffer[] sections = new StringBuffer["ABCDEFGHIJKTXZ".length()];
        for (int i = 0; i < sections.length; ++i) {
            sections[i] = new StringBuffer();
        }
        int ptr = 0;
        try {
            while (!line.matches(REGEX_EVENT_START)) {
                line = this.readLine();
                this.bytesRead += (double)line.length() + 1.0;
            }
            String id = line.replaceFirst("--", "").replaceAll("-A--", "");
            while (!line.startsWith("--") || !line.endsWith("-Z--")) {
                ptr = SyslogAuditEventStream.getSectionIndex(line);
                line = this.readLine();
                this.bytesRead += (double)line.length() + 1.0;
                if (ptr >= 0) {
                    sections[ptr] = new StringBuffer();
                    do {
                        sections[ptr].append(line + "\n");
                        line = this.readLine();
                        this.bytesRead += (double)line.length();
                    } while (!line.trim().matches("^--.*-[A-Z]--$"));
                    continue;
                }
                log.debug("Line contains invalid section-name: " + line);
            }
            String[] data = new String["ABCDEFGHIJKTXZ".length()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = sections[i].toString();
            }
            if (data[0].equals("")) {
                return null;
            }
            AuditEvent event = this.eventFactory.createAuditEvent(id, data, this.inputFile, offset, (long)this.bytesRead - offset, AuditEventType.ModSecurity2);
            event.set("SENSOR_NAME", this.sensor);
            return event;
        }
        catch (EOFException eof) {
            System.out.println("End-of-file reached!");
            this.eofReached = true;
            throw eof;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String readLine() throws IOException {
        if (this.lineReader != null) {
            String l = this.lineReader.readLine();
            log.debug("line: {}", (Object)l);
            if (!this.autoDetection && this.prefix != null) {
                log.debug("CHOPPER: Chopping of with prefix '{}'", (Object)this.prefix);
                int idx = l.indexOf(this.prefix);
                if (idx > 0) {
                    return l.substring(idx + this.prefix.length());
                }
            }
            return l;
        }
        String line = this.readLine(this.tail);
        if (line == null) {
            throw new EOFException("End of file reached!");
        }
        ++this.lines;
        if (this.lines % 1000 == 0) {
            log.debug("{} lines read", (Object)this.lines);
        }
        return this.chop(line);
    }

    protected String chop(String line) {
        if (!this.autoDetection && this.prefix != null) {
            log.debug("CHOPPER: Chopping of with prefix '{}'", (Object)this.prefix);
            int idx = line.indexOf(this.prefix);
            if (idx > 0) {
                String l = line.substring(idx + this.prefix.length());
                log.debug("CHOPPER: line now is '{}'", (Object)l);
                return l;
            }
        }
        return line;
    }

    protected String readLine(boolean blocking) throws IOException {
        String line = this.reader.readLine();
        while (line == null) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            line = this.reader.readLine();
        }
        return line;
    }

    @Override
    public void run() {
        try {
            while (true) {
                AuditEvent event = this.readNext();
                this.listener.eventArrived(event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public Iterator<AuditEvent> iterator() {
        try {
            return new AuditEventIterator(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

