/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.net;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.net.AuditEventStreamHandler;
import org.jwall.web.audit.net.SocketAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogReceiverThread
extends Thread {
    static Logger log = LoggerFactory.getLogger(SyslogReceiverThread.class);
    ServerSocket socket;
    List<AuditEventStreamHandler> handlers = new ArrayList<AuditEventStreamHandler>();
    AuditEventListener listener = null;
    SocketAuthenticator authenticator;

    public SyslogReceiverThread(AuditEventListener l, Integer port) throws Exception {
        this.listener = l;
        this.socket = new ServerSocket(port, 100);
        log.info("Listening for connections on tcp-port {}", (Object)port);
    }

    public SyslogReceiverThread(AuditEventListener l, InetAddress addr, Integer port) throws Exception {
        this.listener = l;
        this.socket = new ServerSocket(port, 100, addr);
        log.info("Listening for connections on " + addr.getHostAddress() + ":" + port);
    }

    public void setSocketAuthenticator(SocketAuthenticator auth) {
        this.authenticator = auth;
    }

    public SocketAuthenticator getSocketAuthenticator() {
        return this.authenticator;
    }

    protected String authenticate(Socket socket) {
        log.debug("Authenticating connection...");
        if (this.authenticator != null) {
            return this.authenticator.authenticate(socket);
        }
        return null;
    }

    @Override
    public void run() {
        while (!this.socket.isClosed()) {
            try {
                String sensor = null;
                Socket connection = this.socket.accept();
                log.info("incoming connection from {}:{}", (Object)connection.getInetAddress().getHostAddress(), (Object)connection.getPort());
                sensor = this.authenticate(connection);
                if (sensor != null) {
                    log.info("Accepting connection from address {} for sensor '{}'", (Object)connection.getInetAddress(), (Object)sensor);
                    AuditEventStreamHandler handler = this.createHandler(connection);
                    handler.start();
                    continue;
                }
                log.warn("Denying TCP connection from {} - no sensor found for that remote address!", (Object)connection.getInetAddress());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuditEventStreamHandler createHandler(Socket connection) throws Exception {
        AuditEventStreamHandler handler = new AuditEventStreamHandler(this, connection, false, true);
        if (this.listener != null) {
            handler.addListener(this.listener);
        }
        List<AuditEventStreamHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.add(handler);
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlerFinished(AuditEventStreamHandler handler) {
        List<AuditEventStreamHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.add(handler);
        }
    }

    public void shutdown() {
        try {
            this.socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("Sending shutdown signal to connection handlers...");
        for (AuditEventStreamHandler handler : this.handlers) {
            handler.close();
        }
        for (AuditEventStreamHandler handler : this.handlers) {
            log.info("Waiting for handler {} to stop", (Object)handler);
            try {
                handler.join();
            }
            catch (Exception e) {
                log.error("Failed to wait for handler: {}", (Throwable)e);
            }
        }
    }
}

