/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.http.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.LinkedList;
import org.jwall.web.http.HttpChunk;
import org.jwall.web.http.HttpHeader;
import org.jwall.web.http.HttpResponse;
import org.jwall.web.http.ProtocolException;
import org.jwall.web.http.nio.HttpMessageChannel;
import org.jwall.web.http.nio.TimeOutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseChannel
extends HttpMessageChannel<HttpResponse> {
    Logger log = LoggerFactory.getLogger((String)"HttpResponseStream.class");
    public static final int STATE_READING_CHUNKS = 2;
    public static final int STATE_CLOSE_CONNECTION = 3;
    int chunkState = 0;
    public static final int READING_CHUNK_HEADER = 0;
    public static final int READING_CHUNK_BODY = 1;
    public static final int READING_CHUNK_TRAILER = 2;
    public static final int READING_CRLF = 3;
    int errors = 0;
    int resNum = 0;
    int cs = -1;
    ByteBuffer chunk = null;
    StringBuffer chunkHeader = new StringBuffer();
    boolean connectionClose = false;
    static int id = 0;
    static int myId = 0;
    LinkedList<ByteBuffer> chunks = new LinkedList();

    public HttpResponseChannel(ReadableByteChannel in) {
        super(in);
        myId = ++id;
    }

    @Override
    public HttpResponse readMessage() throws IOException, TimeOutException, ProtocolException {
        if (this.state == 0) {
            this.header = this.readHeader();
            if (this.header == null) {
                this.log.debug(this + ": unable to read complete header!");
                return null;
            }
            if (this.header.isChunked()) {
                this.state = 2;
                this.chunkState = 0;
                return new HttpResponse(this.header, new byte[0]);
            }
            if (this.header.isConnectionCloseSet() && this.header.getHeader(HttpHeader.CONTENT_LENGTH) == null) {
                this.log.trace("{} Switching to STATE_CLOSE_CONNECTION", (Object)this);
                this.state = 3;
            }
            if (this.header.getContentLength() == 0) {
                this.state = 0;
                this.log.debug("Readirect or the like, with no content, reading header completed!");
                return new HttpResponse(this.header, new byte[0]);
            }
        }
        if (this.header == null) {
            throw new ProtocolException("No header available, though state shows being AFTER reading-header...");
        }
        if (this.header != null && this.state == 3) {
            ByteBuffer b = ByteBuffer.allocate(2048);
            int bytes = this.in.read(b);
            if (bytes > 0) {
                b.flip();
                this.chunks.add(b);
                return null;
            }
            if (this.chunks.isEmpty()) {
                return new HttpResponse(this.header, new byte[0]);
            }
            int size = 0;
            for (ByteBuffer bb : this.chunks) {
                size += bb.limit();
            }
            ByteBuffer body = ByteBuffer.allocate(size);
            for (ByteBuffer bb : this.chunks) {
                body.put(bb);
            }
            this.log.info(this + " Completed reading body: " + size + " bytes read.");
            ++this.resNum;
            return new HttpResponse(this.header, body.array());
        }
        if (this.state == 1) {
            ByteBuffer body;
            if (this.header.getContentLength() > 0 && (body = this.readBody(this.header.getContentLength())) != null) {
                ++this.resNum;
                return new HttpResponse(this.header, body.array());
            }
            if (this.header.isChunked()) {
                this.state = 2;
            }
        }
        if (this.state == 2) {
            HttpChunk ch = this.readChunk();
            if (ch == null) {
                return null;
            }
            ++this.resNum;
            return ch;
        }
        return null;
    }

    public HttpChunk readChunk() throws IOException, ProtocolException {
        String l;
        String line = "";
        if (this.chunkState == 0) {
            this.log.debug(this + " Reading chunk header");
            do {
                if ((line = this.in.readLine()) == null) {
                    return null;
                }
                if ((line = line.trim()).equals("")) {
                    this.log.debug("Skipping empty line before chunk-header...");
                }
                this.chunkHeader.append(line + "\r\n");
            } while (line.equals(""));
            try {
                int colon = line.indexOf(";");
                this.cs = colon > 0 ? Integer.parseInt(line.substring(0, colon), 16) : Integer.parseInt(line.trim(), 16);
            }
            catch (Exception e) {
                System.err.println(this + " Error while parsing chunk-size line: " + line);
                e.printStackTrace();
            }
            this.log.debug(this + ": Chunk header complete, chunk size is " + this.cs);
            this.chunk = ByteBuffer.allocate(this.cs);
            this.chunkState = 1;
        }
        if (this.chunkState == 1) {
            int bytes = 0;
            if (this.chunk.remaining() > 0) {
                bytes = this.in.read(this.chunk);
                this.log.debug(this + ": Read " + bytes + " bytes, chunk has " + this.chunk.remaining() + " bytes missing...");
            }
        }
        if (this.chunk.remaining() == 0) {
            this.log.debug(this + ": Finished reading chunk, size is " + this.chunk.limit());
            this.chunkState = 3;
        }
        if (this.chunkState == 3 && (l = this.in.readLine()) != null) {
            if (l.trim().equals("")) {
                this.chunkState = 0;
                this.log.debug(this + ": Finished reading chunk");
                if (this.chunk.limit() == 0) {
                    ++this.resNum;
                    this.state = 0;
                }
                return new HttpChunk(line, this.chunk);
            }
            throw new ProtocolException(this + ": Error, expected blank-line after chunk, found: " + l);
        }
        this.log.debug(this + ": Reading chunk not completed.");
        return null;
    }

    public String toString() {
        return "HttpResponseChannel[" + myId + " response #" + this.resNum + "] " + this.status() + " " + this.chunkState();
    }

    public String status() {
        if (this.state == 0) {
            return "_READING_HEADER_";
        }
        if (this.state == 1) {
            return "_READING_BODY_";
        }
        if (this.state == 2) {
            return "_READING_CHUNKS_";
        }
        if (this.state == 3) {
            return "_CLOSING_CONNECTION_";
        }
        return "UNKNOWN_STATE";
    }

    public String chunkState() {
        if (this.chunkState == 0) {
            return "READING_CHUNK_HEADER";
        }
        if (this.chunkState == 1) {
            return "READING_CHUNK_BODY";
        }
        if (this.chunkState == 2) {
            return "READING_CHUNK_TRAILER";
        }
        if (this.chunkState == 3) {
            return "READING_CRLF";
        }
        return "UNKNOWN_CHUNK_STATE";
    }

    public boolean isConnectionClosed() {
        return this.connectionClose;
    }

    public int getNumberOfResponses() {
        return this.resNum;
    }

    public int getId() {
        return myId;
    }
}

