/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.session;

import java.util.Set;
import java.util.TreeSet;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.session.AbstractSessionTracker;
import org.jwall.web.audit.session.Session;

public class CookieSessionTracker
extends AbstractSessionTracker {
    private String sessionCookie;
    private Set<String> valid = new TreeSet<String>();

    public CookieSessionTracker(String cookieName) {
        this.type = 1;
        this.sessionCookie = cookieName;
        this.valid = new TreeSet<String>();
    }

    @Override
    public String extractKey(AuditEvent evt) {
        String var = "REQUEST_COOKIES:" + this.sessionCookie;
        log.debug("Looking up cookie by variable '" + var + "'");
        String sid = evt.get(var);
        log.debug("    value = '" + sid + "'");
        if (sid != null) {
            if (this.valid.contains(sid) || !this.strictSessions) {
                return sid;
            }
            log.warn("No valid session found for ID '" + sid + "'!");
            return null;
        }
        sid = evt.get("RESPONSE_COOKIES:" + this.sessionCookie);
        if (sid != null) {
            log.debug("Creating new session from response:  Set-Cookie: '{}' = {}", (Object)this.sessionCookie, (Object)sid);
            this.valid.add(sid);
            return sid;
        }
        return null;
    }

    @Override
    public void expireSession(Session s) {
        super.expireSession(s);
        this.valid.remove(s.getId());
    }

    @Override
    public String toString() {
        return "CookieSessionTracker[" + this.sessionCookie + "," + this.sessionTimeOut + "]";
    }
}

