/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.jwall.log.io.MParser;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventMessage;
import org.jwall.web.audit.ModSecurity;
import org.jwall.web.audit.ModSecurityEventMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageParser
extends MParser {
    static Logger log = LoggerFactory.getLogger(MessageParser.class);
    static XStream xstream = new XStream();

    public static List<AuditEventMessage> parseMessages(AuditEvent evt) {
        LinkedList<AuditEventMessage> msgs = new LinkedList<AuditEventMessage>();
        try {
            if (evt.getSection(7) == null) {
                return msgs;
            }
            BufferedReader r = new BufferedReader(new StringReader(evt.getSection(7)));
            String line = r.readLine();
            while (line != null) {
                if (line.startsWith("Message: ")) {
                    String ruleMsg;
                    String severity;
                    String data;
                    String id;
                    String lineNr;
                    log.debug("Parsing: {}", (Object)line);
                    ModSecurityEventMessage m = new ModSecurityEventMessage();
                    String theMesg = line.substring("Message: ".length());
                    String file = MessageParser.extract("file", theMesg);
                    m.setFile(file);
                    if (file != null) {
                        theMesg = MessageParser.remove("file", theMesg);
                    }
                    if ((lineNr = MessageParser.extract("line", theMesg)) != null) {
                        try {
                            m.setLine(Integer.parseInt(lineNr));
                        }
                        catch (Exception e) {
                            log.error("Not a line-number: {}", (Object)lineNr);
                            e.printStackTrace();
                        }
                        theMesg = MessageParser.remove("line", theMesg);
                    }
                    if ((id = MessageParser.extract("id", theMesg)) != null) {
                        m.setRuleId(id);
                        theMesg = MessageParser.remove("id", theMesg);
                    }
                    if ((data = MessageParser.extract("data", theMesg)) != null) {
                        m.setRuleData(data);
                        theMesg = MessageParser.remove("data", theMesg);
                    }
                    if ((severity = MessageParser.extract("severity", theMesg)) != null) {
                        m.setSeverity(ModSecurity.getSeverity(severity));
                        theMesg = MessageParser.remove("severity", theMesg);
                    }
                    if ((ruleMsg = MessageParser.extract("msg", theMesg)) != null) {
                        theMesg = MessageParser.remove("msg", theMesg);
                        m.setRuleMsg(ruleMsg);
                    }
                    String tag = MessageParser.extract("tag", theMesg);
                    while (tag != null) {
                        theMesg = MessageParser.remove("tag", theMesg);
                        m.setTag(tag);
                        tag = MessageParser.extract("tag", theMesg);
                    }
                    m.setText(theMesg.trim());
                    msgs.add(m);
                } else {
                    log.debug("Skipping: {}", (Object)line);
                }
                line = r.readLine();
            }
            r.close();
        }
        catch (Exception e) {
            log.error("Failed to parse messages from event {}: {}", (Object)evt.getEventId(), (Object)e.getMessage());
            e.printStackTrace();
        }
        return msgs;
    }

    public static AuditEventMessage parseMessage(String line) {
        if (line.startsWith("Message: ")) {
            String ruleMsg;
            String severity;
            String data;
            String id;
            String lineNr;
            ModSecurityEventMessage m = new ModSecurityEventMessage();
            String theMesg = line.substring("Message: ".length());
            String file = MessageParser.extract("file", theMesg);
            m.setFile(file);
            if (file != null) {
                theMesg = MessageParser.remove("file", theMesg);
            }
            if ((lineNr = MessageParser.extract("line", theMesg)) != null) {
                try {
                    m.setLine(Integer.parseInt(lineNr));
                }
                catch (Exception e) {
                    log.error("Not a line-number: {}", (Object)lineNr);
                    e.printStackTrace();
                }
                theMesg = MessageParser.remove("line", theMesg);
            }
            if ((id = MessageParser.extract("id", theMesg)) != null) {
                m.setRuleId(id);
                theMesg = MessageParser.remove("id", theMesg);
            }
            if ((data = MessageParser.extract("data", theMesg)) != null) {
                m.setRuleData(data);
                theMesg = MessageParser.remove("data", theMesg);
            }
            if ((severity = MessageParser.extract("severity", theMesg)) != null) {
                m.setSeverity(ModSecurity.getSeverity(severity));
                theMesg = MessageParser.remove("severity", theMesg);
            }
            if ((ruleMsg = MessageParser.extract("msg", theMesg)) != null) {
                theMesg = MessageParser.remove("msg", theMesg);
                m.setRuleMsg(ruleMsg);
            }
            String tag = MessageParser.extract("tag", theMesg);
            while (tag != null) {
                theMesg = MessageParser.remove("tag", theMesg);
                m.setTag(tag);
                tag = MessageParser.extract("tag", theMesg);
            }
            m.setText(theMesg.trim());
            return m;
        }
        return null;
    }

    public static String extract(String tag, String line) {
        log.debug("trying to extract {} from line {}", (Object)tag, (Object)line);
        try {
            String start = "[" + tag + " \"";
            String end = "\"]";
            int fileIndex = line.indexOf(start);
            if (fileIndex > 0) {
                int fileEnd = line.indexOf(end, fileIndex);
                String data = "";
                data = fileEnd < 0 ? line.substring(fileIndex + start.length()) : line.substring(fileIndex + start.length(), fileEnd);
                return data;
            }
        }
        catch (Exception e) {
            log.error("Failed to extract {}: {}", (Object)tag, (Object)e.getMessage());
        }
        return null;
    }

    public static String remove(String tag, String line) {
        log.debug("trying to remove {} from line {}", (Object)tag, (Object)line);
        String start = "[" + tag + " \"";
        String end = "\"]";
        try {
            int fileIndex = line.indexOf(start);
            if (fileIndex > 0) {
                int fileEnd = line.indexOf(end, fileIndex);
                if (fileEnd < 0) {
                    return "";
                }
                line = line.substring(0, fileIndex) + line.substring(fileEnd + end.length());
                return line;
            }
        }
        catch (Exception e) {
            log.error("Failed to extract {}: {}", (Object)tag, (Object)e.getMessage());
        }
        return line;
    }

    static {
        xstream.processAnnotations(new Class[]{AuditEventMessage.class});
    }
}

