/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.io.AuditEventWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogFileWriter
extends Thread
implements AuditEventListener,
AuditEventWriter {
    private static Logger log = LoggerFactory.getLogger((String)"AuditLogFileWriter");
    public static final String VERSION = "$Revision: 128 $";
    private BlockingQueue<AuditEvent> queue;
    private static HashMap<String, PrintWriter> writers = new HashMap();
    boolean hostBasedLogs = true;
    File logDir = new File("/tmp");
    double eventCount = 0.0;
    Hashtable<String, String> map;
    String key = "Host";
    boolean steady = true;
    boolean finished = false;

    public AuditLogFileWriter(File dir, int logLevel, String groupBy) {
        this(dir, true, logLevel);
        this.key = groupBy;
    }

    public AuditLogFileWriter(File dir, boolean hostBased, int logLevel) {
        this.hostBasedLogs = hostBased;
        this.queue = new LinkedBlockingQueue<AuditEvent>(25000);
        this.logDir = dir;
        this.map = new Hashtable();
        try {
            PrintWriter w = null;
            if (!dir.isDirectory()) {
                log.debug("Writing all events to file {}", (Object)dir.getAbsolutePath());
                this.hostBasedLogs = false;
                w = new PrintWriter(new FileWriter(dir));
            } else if (dir.isFile()) {
                this.hostBasedLogs = false;
                w = new PrintWriter(new FileWriter(dir.getAbsoluteFile()));
            } else {
                w = new PrintWriter(new FileWriter(dir.getAbsolutePath() + "/default-audit.log"));
            }
            writers.put("__default__", w);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.finished) {
            try {
                int count = 0;
                while (!this.queue.isEmpty()) {
                    AuditEvent evt = (AuditEvent)this.queue.poll();
                    if (evt == null) continue;
                    this.writeEvent(evt);
                    if (count++ % 100 == 0) {
                        System.out.print("w");
                    }
                    this.eventCount += 1.0;
                }
                if (!this.steady) {
                    this.finished = true;
                }
                int sleep = 64;
                while (this.queue.isEmpty() && !this.finished) {
                    Thread.sleep(sleep);
                    if (sleep >= 500) continue;
                    sleep *= 2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void writeEvent(AuditEvent evt) throws IOException {
        String host = this.extractKey(evt);
        if (host == null) {
            host = "errors";
        }
        if (host.indexOf(":") > 0) {
            host = host.substring(0, host.indexOf(":"));
        }
        if (!this.hostBasedLogs) {
            host = "__default__";
        } else if (this.map.get(host) != null) {
            host = this.map.get(host);
        }
        host = host.toLowerCase();
        PrintWriter wr = writers.get(host);
        if (wr == null) {
            wr = new PrintWriter(new FileWriter(this.logDir.getAbsolutePath() + "/" + host + "-audit.log", true));
            writers.put(host, wr);
        }
        boolean nl = true;
        if (evt.getSection(0).endsWith("\n")) {
            nl = false;
        }
        for (int i = 0; i < "ABCDEFGHIJKTXZ".length(); ++i) {
            char sec = "ABCDEFGHIJKTXZ".charAt(i);
            if ("".equals(evt.getSection(i))) continue;
            wr.println("--" + evt.getEventId() + "-" + sec + "--");
            if (nl) {
                wr.println(evt.getSection(i));
                continue;
            }
            wr.print(evt.getSection(i));
        }
        wr.println("--" + evt.getEventId() + "-Z--");
        wr.flush();
    }

    private String extractKey(AuditEvent evt) {
        if ("SESSION_ID".equals(this.key)) {
            return evt.getSessionId();
        }
        if (!this.hostBasedLogs) {
            return null;
        }
        return evt.get("REQUEST_HEADERS:Host");
    }

    @Override
    public synchronized void eventArrived(AuditEvent evt) {
        if (evt != null) {
            this.queue.add(evt);
        }
    }

    public void add(AuditEvent evt) {
        this.queue.add(evt);
    }

    public void add(Collection<AuditEvent> evts) {
        this.queue.addAll(evts);
    }

    public void addEventListener(AuditEventListener listener) {
    }

    public double[] getStatistics() {
        double[] data = new double[]{this.eventCount};
        this.eventCount = 0.0;
        return data;
    }

    public String[] getColumnNames() {
        return new String[]{"eventCount"};
    }

    public String getFile() {
        return "AuditLogFileWriter";
    }

    public void addAlias(String alias, String server) {
        this.map.put(alias, server);
    }

    public boolean hasEventsPending() {
        return !this.queue.isEmpty();
    }

    public int eventsPending() {
        return this.queue.size();
    }

    @Override
    public void eventsArrived(Collection<AuditEvent> events) {
        this.addEvents(events);
    }

    public void addEvents(Collection<AuditEvent> events) {
        this.queue.addAll(events);
    }

    public int length() {
        return this.queue.size();
    }

    public int left() {
        return this.queue.size();
    }

    public void setSteadyWriter(boolean b) {
        this.steady = b;
    }

    public void close() {
        this.finished = true;
    }
}

