/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.filter;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jwall.audit.Match;
import org.jwall.web.audit.SyntaxException;
import org.jwall.web.audit.filter.AuditEventFilter;
import org.jwall.web.audit.filter.AuditEventMatch;
import org.jwall.web.audit.filter.BooleanOperator;
import org.jwall.web.audit.filter.ExpressionReader;
import org.jwall.web.audit.filter.FilterException;
import org.jwall.web.audit.filter.FilterExpression;
import org.jwall.web.audit.filter.FilterExpressionList;
import org.jwall.web.audit.filter.Operator;
import org.jwall.web.audit.rules.Condition;
import org.jwall.web.audit.rules.operators.AbstractCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterCompiler {
    static Logger log = LoggerFactory.getLogger(FilterCompiler.class);

    public Condition createCondition(FilterExpression e) throws SyntaxException {
        if (e instanceof Match) {
            Match m = (Match)((Object)e);
            return AbstractCondition.createCondition(m.getOp(), m.getVariable(), m.getValue());
        }
        throw new FilterException("Don't know how to compile condition from expression " + e + "!");
    }

    public static final FilterExpression map(AuditEventFilter filter) throws FilterException {
        if (filter == null || filter.getMatches().isEmpty()) {
            return null;
        }
        StringBuffer s = new StringBuffer();
        Iterator<AuditEventMatch> it = filter.getMatches().iterator();
        while (it.hasNext()) {
            AuditEventMatch m = it.next();
            s.append(m.getVariable());
            s.append(" ");
            s.append(m.getOperator());
            s.append(" ");
            if (m.getValue().indexOf(" ") >= 0) {
                s.append("'");
                s.append(m.getValue());
                s.append("'");
            } else {
                s.append(m.getValue());
            }
            if (!it.hasNext()) continue;
            s.append(" AND ");
        }
        return FilterCompiler.parse(s.toString());
    }

    public static final FilterExpression parse(String str) throws FilterException {
        log.debug("Parsing expression: '{}'", (Object)str);
        if (str == null || str.trim().isEmpty()) {
            return new AuditEventFilter();
        }
        ExpressionReader r = new ExpressionReader(str);
        return r.readFilterExpression();
    }

    public static final FilterExpression parse(String str, Collection<String> variables) throws FilterException {
        log.debug("Parsing expression: '{}'", (Object)str);
        ExpressionReader r = new ExpressionReader(str, variables);
        return r.readFilterExpression();
    }

    public static final FilterExpression parse(String str, Collection<String> variables, Set<Operator> operators) throws FilterException {
        log.debug("Parsing expression: '{}'", (Object)str);
        ExpressionReader r = new ExpressionReader(str, variables, operators);
        return r.readFilterExpression();
    }

    public static final FilterExpression parse(String str, Collection<String> variables, Set<Operator> operators, Set<BooleanOperator> boolOps) throws FilterException {
        log.debug("Parsing expression: '{}'", (Object)str);
        ExpressionReader r = new ExpressionReader(str, variables, operators);
        r.setBooleanOperators(boolOps);
        return r.readFilterExpression();
    }

    public static final AuditEventFilter compile(String str) throws FilterException {
        return FilterCompiler.compile(FilterCompiler.parse(str));
    }

    public static final AuditEventFilter compile(String str, Collection<String> variables) throws FilterException {
        return FilterCompiler.compile(FilterCompiler.parse(str, variables));
    }

    public static final AuditEventFilter compile(String str, Set<String> variables, Set<Operator> operators) throws FilterException {
        return FilterCompiler.compile(FilterCompiler.parse(str, variables, operators));
    }

    public static final AuditEventFilter compile(String str, Set<String> variables, Set<Operator> operators, Set<BooleanOperator> boolOps) throws FilterException {
        return FilterCompiler.compile(FilterCompiler.parse(str, variables, operators, boolOps));
    }

    public static final AuditEventFilter compile(FilterExpression exp) throws FilterException {
        AuditEventFilter filter = new AuditEventFilter();
        if (FilterCompiler.map(exp) != null) {
            filter.add(FilterCompiler.map(exp));
        }
        if (exp instanceof FilterExpressionList) {
            FilterExpressionList list = (FilterExpressionList)exp;
            for (FilterExpression e : FilterCompiler.expand(list)) {
                if (FilterCompiler.map(e) == null) continue;
                filter.add(FilterCompiler.map(e));
            }
        }
        return filter;
    }

    public static List<FilterExpression> expand(FilterExpressionList list) {
        LinkedList<FilterExpression> exp = new LinkedList<FilterExpression>();
        for (FilterExpression e : list.getElements()) {
            if (e instanceof FilterExpressionList) {
                exp.addAll(FilterCompiler.expand((FilterExpressionList)e));
                continue;
            }
            exp.add(e);
        }
        return exp;
    }

    public static final Match map(FilterExpression e) {
        if (e instanceof Match) {
            return (Match)((Object)e);
        }
        if (e instanceof AuditEventMatch) {
            AuditEventMatch aem = (AuditEventMatch)e;
            return new Match(aem.getVariable(), aem.getOp(), aem.getValue());
        }
        return null;
    }

    public static final String toFilterString(Object e) {
        if (e == null) {
            return "null";
        }
        if (e instanceof FilterExpressionList) {
            return ((FilterExpressionList)e).toString();
        }
        if (e instanceof AuditEventMatch) {
            AuditEventMatch m = (AuditEventMatch)e;
            return m.getVariable() + " " + m.getOperator() + " " + m.getValue();
        }
        if (e instanceof AuditEventFilter) {
            StringBuffer s = new StringBuffer();
            AuditEventFilter aef = (AuditEventFilter)e;
            Iterator<AuditEventMatch> it = aef.getMatches().iterator();
            while (it.hasNext()) {
                AuditEventMatch match = it.next();
                s.append(match.getVariable());
                s.append(" ");
                s.append(match.getOperator());
                s.append(" ");
                s.append(match.getValueObject());
                if (!it.hasNext()) continue;
                s.append(" AND ");
            }
            return s.toString();
        }
        return e.toString();
    }
}

