/*
 *  Copyright (C) 2007-2014 Christian Bockermann <chris@jwall.org>
 *
 *  This file is part of the  web-audit  library.
 *
 *  web-audit library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The  web-audit  library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package org.jwall.web.audit.test;

import java.util.ArrayList;
import java.util.List;

import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.filter.FilterExpression;

public class RegressionTester {

	public static List<String> test(AuditEvent evt, String testSection)
			throws Exception {
		List<String> errors = new ArrayList<String>();

		List<FilterExpression> tests = TestParser.parse(testSection);
		for (FilterExpression test : tests) {
			if (!test.matches(evt))
				errors.add("Test '" + test + "' failed on event "
						+ evt.getEventId());
		}
		return errors;
	}
}
