/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.io.AbstractAuditEventReader;
import org.jwall.web.audit.io.AccessLogAuditReader;
import org.jwall.web.audit.io.AuditEventReader;
import org.jwall.web.audit.io.AuditFormat;
import org.jwall.web.audit.io.ModSecurity2AuditReader;
import org.jwall.web.audit.io.ModSecurityAuditReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RFICollector
extends Thread
implements AuditEventListener {
    public static final String VERSION = "0.0.1";
    private static Logger log = LoggerFactory.getLogger((String)"org.jwall.web.audit.util.RFICollector");
    public static final String PROPERTY_TAIL = "org.jwall.rfi.tail";
    public static final String PROPERTY_FOLLOW_FILES = "org.jwall.rfi.follow-files";
    public static final String PROPERTY_FILES_ONLY = "org.jwall.rfi.files-only";
    public static final String PROPERTY_DOWNLOAD = "org.jwall.rfi.download";
    public static final String PROPERTY_SITE_DIRS = "org.jwall.rfi.site.dirs";
    public static final String PROPERTY_DATA_DIR = "org.jwall.rfi.data-dir";
    public static final String PROPERTY_LOG_FILE = "org.jwall.rfi.log-file";
    public static final String PROPERTY_PRESERVE_URL = "org.jwall.rfi.preserve-url";
    File dataDir;
    AuditEventReader reader;
    Properties props = new Properties();
    SortedSet<String> references = new TreeSet<String>();
    LinkedBlockingQueue<URL> remoteReferences = new LinkedBlockingQueue();
    boolean finished = false;
    Integer cnt = 0;
    Long check = 0L;

    public RFICollector(Properties p) throws Exception {
        this.props = new Properties();
        for (Object k : p.keySet()) {
            this.props.put(k, new String(p.getProperty(k.toString())));
        }
        boolean tail = "true".equals(this.props.getProperty(PROPERTY_TAIL));
        this.reader = RFICollector.createReader(this.props.getProperty(PROPERTY_LOG_FILE), tail);
        this.dataDir = new File(this.props.getProperty(PROPERTY_DATA_DIR));
    }

    public RFICollector(AuditEventReader source, Properties p) throws Exception {
        this.props = new Properties();
        for (Object k : p.keySet()) {
            this.props.put(k, new String(p.getProperty(k.toString())));
        }
        this.reader = source;
        this.dataDir = new File(this.props.getProperty(PROPERTY_DATA_DIR));
    }

    @Override
    public void run() {
        try {
            AuditEvent evt = null;
            while (!this.finished) {
                try {
                    evt = this.reader.readNext();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (evt == null) {
                    if ("true".equalsIgnoreCase(System.getProperty(PROPERTY_TAIL))) {
                        StringBuffer s = new StringBuffer();
                        for (String ref : this.references) {
                            s.append(ref + "\n");
                        }
                        log.info("Analyzed " + this.cnt + " events, found " + this.references.size() + " remote references:\n" + s.toString());
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                Integer n = this.cnt;
                Integer n2 = this.cnt = Integer.valueOf(this.cnt + 1);
                this.handleEvent(evt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getCount() {
        return this.cnt;
    }

    public List<String> extractRemoteReferences(AuditEvent evt) {
        LinkedList<String> rfr = new LinkedList<String>();
        for (String param : evt.getAll("ARGS_GET")) {
            List<String> vals = evt.getAll("ARGS_GET:" + param);
            for (String val : vals) {
                if (val == null || !val.startsWith("http://")) continue;
                rfr.add(val);
                log.debug("Found remote file reference: " + val);
                System.out.println("Found remote file reference: " + val);
            }
        }
        if ("POST".equalsIgnoreCase(evt.get("REQUEST_METHOD"))) {
            for (String param : evt.getAll("ARGS_POST")) {
                for (String val : evt.getAll("ARGS_POST:" + param)) {
                    if (val == null || !val.startsWith("http://")) continue;
                    rfr.add(val);
                    log.debug("Found remote file reference: " + val);
                    System.out.println("Found remote file reference: " + val);
                }
            }
        }
        return rfr;
    }

    @Override
    public void eventArrived(AuditEvent e) {
        this.handleEvent(e);
    }

    @Override
    public void eventsArrived(Collection<AuditEvent> events) {
        for (AuditEvent evt : events) {
            this.eventArrived(evt);
        }
    }

    public void handleEvent(AuditEvent evt) {
        List<String> rfr = this.extractRemoteReferences(evt);
        for (String rf : rfr) {
            try {
                URL url = new URL(rf);
                StringBuffer meta = new StringBuffer();
                meta.append("ScriptEvent-ID: " + evt.getEventId() + "\n");
                meta.append("Date: " + new Date() + "\n");
                meta.append("URL: " + url + "\n");
                if (!this.references.contains(rf)) {
                    this.references.add(rf);
                }
                log.info("Downloading from URL " + url);
                String data = this.download(url);
                String id = this.md5("" + url);
                File out = new File(this.dataDir + "/" + id + ".dat");
                log.info(" output-file : " + out.getAbsolutePath());
                if ("true".equalsIgnoreCase(System.getProperty(PROPERTY_PRESERVE_URL))) {
                    id = url.getPath().replaceAll("/", "_");
                    out = new File(this.dataDir + "/" + url.getHost() + "/" + url.getPath().replaceAll("/", "_"));
                    if (out.getParentFile() != null) {
                        out.getParentFile().mkdirs();
                    }
                }
                if (out.exists()) {
                    meta.append("Msg: output-file exists!\n");
                } else {
                    FileWriter fos = new FileWriter(out);
                    fos.write(data);
                    fos.close();
                    meta.append("File: " + out.getAbsolutePath() + "\n");
                }
                FileWriter info = new FileWriter(new File(this.dataDir + "/" + id + ".txt"));
                info.write(meta.toString());
                info.close();
            }
            catch (Exception e) {
                log.warn("Exception: " + e.getMessage());
            }
        }
        if (this.cnt == 0) {
            this.check = System.currentTimeMillis();
        }
        Integer mod = 5000;
        if (this.cnt > 0 && this.cnt % mod == 0) {
            double d = mod.doubleValue();
            Long dur = System.currentTimeMillis() - this.check;
            double sec = dur.doubleValue() / 1000.0;
            this.check = System.currentTimeMillis();
            System.out.println("Processed " + this.cnt + " events (" + d / sec + " evts/s)");
        }
    }

    public String download(URL url) throws Exception {
        StringBuffer data = new StringBuffer();
        if ("true".equalsIgnoreCase(this.props.getProperty(PROPERTY_DOWNLOAD))) {
            log.info("Starting to download \"" + url + "\"");
            URLConnection con = url.openConnection();
            con.setRequestProperty("user-agent", "");
            con.setConnectTimeout(2000);
            con.setReadTimeout(2000);
            con.connect();
            InputStream in = con.getInputStream();
            int b = -1;
            int bytes = 0;
            do {
                if ((b = in.read()) == -1) continue;
                data.append((char)b);
                ++bytes;
            } while (b != -1);
            log.info(bytes + " bytes downloaded.");
        } else {
            log.info("download-option org.jwall.rfi.download not enabled!");
        }
        return data.toString();
    }

    public void finish() {
        this.finished = true;
    }

    public String md5(String data) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(data.getBytes());
        BigInteger bi = new BigInteger(md.digest()).abs();
        return bi.toString(16);
    }

    public static AuditEventReader createReader(String f, boolean tail) throws Exception {
        System.out.println("Creating AuditEventReader from " + f);
        AbstractAuditEventReader reader = null;
        File logFile = new File(f);
        int fmt = AuditFormat.guessFormat(logFile);
        if (fmt == 0) {
            reader = new AccessLogAuditReader(logFile, tail);
        }
        if (fmt == 1) {
            reader = new ModSecurityAuditReader(logFile, tail);
        }
        if (fmt == 2) {
            reader = new ModSecurity2AuditReader(logFile, tail);
        }
        if (reader == null) {
            throw new Exception("The log-file format is not supported!");
        }
        return reader;
    }

    public static void loadProperties(File file) throws IOException {
        if (file.exists()) {
            System.out.println("Reading properties from \"" + file.getAbsolutePath() + "\"...");
            Properties p = new Properties();
            p.load(new FileInputStream(file));
            for (Object key : p.keySet()) {
                System.setProperty(key.toString(), p.getProperty(key.toString()));
            }
        }
    }

    public static void main(String[] args) {
        try {
            File logFile;
            AuditEventReader reader;
            File properties;
            if (System.getProperty(PROPERTY_DOWNLOAD) == null) {
                System.setProperty(PROPERTY_DOWNLOAD, "false");
            }
            if (System.getProperty(PROPERTY_TAIL) == null) {
                System.setProperty(PROPERTY_TAIL, "false");
            }
            if (System.getProperty(PROPERTY_SITE_DIRS) == null) {
                System.setProperty(PROPERTY_SITE_DIRS, "true");
            }
            if (System.getProperty(PROPERTY_FILES_ONLY) == null) {
                System.setProperty(PROPERTY_FILES_ONLY, "false");
            }
            if (System.getProperty(PROPERTY_DATA_DIR) == null) {
                System.setProperty(PROPERTY_DATA_DIR, ".");
            }
            if (args.length == 0) {
                System.out.println("This is the RFI-Collector for web-server logs, version 0.0.1");
                System.out.println("Usage:\n\tjava org.jwall.web.audit.util.RFICollector [options] log-file\n\n");
                System.exit(0);
            }
            if ((properties = new File(System.getProperty("user.home") + "/" + ".rfi-collector.properties")).exists()) {
                RFICollector.loadProperties(properties);
            }
            File dataDir = new File("./");
            int i = 0;
            while (i + 1 < args.length) {
                if ("-c".equals(args[i]) || "--config".equals(args[i])) {
                    File cfg = new File(args[i + 1]);
                    if (cfg.exists() && cfg.canRead()) {
                        RFICollector.loadProperties(cfg);
                    } else {
                        System.out.println("Unable to read properties from \"" + args[i + 1] + "\"!");
                    }
                }
                if ("-o".equals(args[i]) || "--output".equals(args[i])) {
                    dataDir = new File(args[i + 1]);
                    if (!dataDir.exists()) {
                        dataDir.mkdirs();
                    }
                    if (!dataDir.isDirectory()) {
                        throw new Exception("Output location \"" + dataDir.getAbsolutePath() + "\" is not a directory!");
                    }
                }
                ++i;
            }
            System.out.println("Config:");
            for (Object key : System.getProperties().keySet()) {
                if (!key.toString().startsWith("org.jwall")) continue;
                System.out.println("" + key.toString() + "=" + System.getProperty(key.toString()));
            }
            if (System.getProperty(PROPERTY_LOG_FILE) == null) {
                System.setProperty(PROPERTY_LOG_FILE, new File(args[args.length - 1]).getAbsolutePath());
            }
            if ((reader = AuditFormat.createReader((logFile = new File(System.getProperty(PROPERTY_LOG_FILE))).getAbsolutePath(), false)) == null) {
                throw new Exception("The log-file format is not supported!");
            }
            RFICollector col = new RFICollector(System.getProperties());
            col.run();
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

