/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.rbl.dns;

import org.jwall.rbl.dns.DNSParser;

public final class QuerySection {
    public static final int QUERY_CLASS_IN = 1;
    public static final int QUERY_TYPE_A = 1;
    public static final int QUERY_TYPE_NS = 2;
    public static final int QUERY_TYPE_CNAME = 5;
    public static final int QUERY_TYPE_SOA = 6;
    public static final int QUERY_TYPE_PTR = 12;
    public static final int QUERY_TYPE_MX = 15;
    public static final int QUERY_TYPE_TXT = 16;
    int qc = 1;
    int qt = 1;
    byte[] qname = new byte[0];

    private QuerySection() {
    }

    public int getQClass() {
        return this.qc;
    }

    public int getQType() {
        return this.qt;
    }

    public String getQName() {
        StringBuffer s = new StringBuffer();
        String[] vals = DNSParser.readDNSstring(this.qname);
        for (int i = 0; i < vals.length; ++i) {
            s.append(vals[i]);
            if (i + 1 >= vals.length) continue;
            s.append(".");
        }
        return s.toString();
    }

    public int length() {
        return this.qname.length + 2 + 2;
    }

    public static QuerySection read(byte[] buf, int offset) throws Exception {
        QuerySection sect = new QuerySection();
        int ptr = offset;
        byte len = buf[ptr++];
        while (len > 0) {
            ptr += len;
            len = buf[ptr++];
        }
        sect.qname = new byte[ptr - offset];
        for (int i = offset; i < ptr; ++i) {
            sect.qname[i - offset] = buf[i];
        }
        int firstByte = 0xFF & buf[ptr++];
        int secondByte = 0xFF & buf[ptr++];
        sect.qt = firstByte << 8 | secondByte;
        firstByte = 0xFF & buf[ptr++];
        secondByte = 0xFF & buf[ptr++];
        sect.qc = firstByte << 8 | secondByte;
        return sect;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.length()];
        int ptr = 0;
        for (int i = 0; i < this.qname.length; ++i) {
            data[ptr++] = this.qname[i];
        }
        data[ptr++] = (byte)((this.qt & 0xFF00) >> 8);
        data[ptr++] = (byte)(this.qt & 0xFF);
        data[ptr++] = (byte)((this.qc & 0xFF00) >> 8);
        data[ptr++] = (byte)(this.qc & 0xFF);
        return data;
    }
}

