/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.rbl.dns;

import java.net.InetAddress;
import org.jwall.rbl.RblServer;
import org.jwall.rbl.data.RBListEntry;
import org.jwall.rbl.dns.ARecord;
import org.jwall.rbl.dns.PtrRecord;
import org.jwall.rbl.dns.Query;
import org.jwall.rbl.dns.QuerySection;
import org.jwall.rbl.dns.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHandler {
    static Logger log = LoggerFactory.getLogger(QueryHandler.class);
    String pattern = ".*(block-\\d+|unblock)\\.rbl\\.localnet$";
    String domain = "rbl.localnet";
    RblServer server;

    public QueryHandler(RblServer server) {
        this.server = server;
        this.domain = server.getDomain();
        this.pattern = ".*(block-\\d+|unblock)\\." + this.domain + "$";
    }

    public synchronized Response process(InetAddress source, Query q) {
        Response response = new Response(q);
        for (QuerySection sect : q.getSections()) {
            RBListEntry entry;
            String queryValue = sect.getQName();
            log.debug("Received query for '{}'", (Object)queryValue);
            if (!queryValue.endsWith(".") && !queryValue.endsWith(this.domain)) {
                queryValue = queryValue + "." + this.domain;
            }
            if (sect.getQClass() == 12) {
                entry = this.server.getBlockList().lookup(queryValue);
                if (entry != null && !entry.isExpired()) {
                    response.add(new PtrRecord(queryValue, queryValue, (int)entry.getRemainingLifetime()));
                } else {
                    response.setStatus(3);
                    break;
                }
            }
            if (sect.getQType() == 1) {
                queryValue = this.preprocess(source, queryValue);
                entry = this.server.getBlockList().lookup(queryValue);
                if (entry != null && !entry.isExpired()) {
                    log.debug("Entry '{}' is on block list and will expire in {} seconds", (Object)queryValue, (Object)entry.getRemainingLifetime());
                    response.add(new ARecord(queryValue, RblServer.BLOCKED_VALUE, (int)entry.getRemainingLifetime()));
                    continue;
                }
                log.debug("Removing expired entry...");
                response.setStatus(3);
                if (entry == null) continue;
                this.server.getBlockList().remove(entry.getName());
                continue;
            }
            response.setStatus(3);
        }
        return response;
    }

    protected String preprocess(InetAddress source, String queryValue) {
        if (!queryValue.matches(this.pattern)) {
            return queryValue;
        }
        int idx = queryValue.lastIndexOf("." + this.domain);
        String part = queryValue.substring(0, idx);
        int start = part.lastIndexOf(".");
        String action = part.substring(start);
        String key = queryValue.replaceFirst(action, "");
        if (action.startsWith(".block-")) {
            block7: {
                if (!this.server.getRblSecurityManager().hasPermission(source, "block")) {
                    log.error("No permission for action 'block' for address '{}'", (Object)source.getHostAddress());
                    return key;
                }
                try {
                    Integer ttl = new Integer(action.substring(7));
                    log.debug("Need to block key: '{}' for {} seconds", (Object)key, (Object)ttl);
                    this.server.block(key, ttl);
                    queryValue = key;
                }
                catch (Exception e) {
                    log.error("Failed to block entry: '{}': {}", (Object)queryValue, (Object)e.getMessage());
                    if (!log.isDebugEnabled()) break block7;
                    e.printStackTrace();
                }
            }
            return queryValue;
        }
        if (action.equals(".unblock")) {
            if (!this.server.getRblSecurityManager().hasPermission(source, "unblock")) {
                log.error("No permission for action 'block' for address '{}'", (Object)source.getHostAddress());
                return key;
            }
            this.server.unblock(key);
        }
        return key;
    }

    public static String getKeyForAddress(String address, String domain) {
        if (address.endsWith(domain)) {
            return address;
        }
        StringBuffer key = new StringBuffer(address);
        String[] tok = address.split("\\.");
        key = new StringBuffer();
        for (int i = tok.length - 1; i >= 0; --i) {
            key.append(tok[i]);
            if (i <= 0) continue;
            key.append(".");
        }
        if (!domain.startsWith(".")) {
            key.append(".");
        }
        key.append(domain);
        return key.toString();
    }
}

