/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.rbl.data;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.jwall.rbl.RblServer;

public class RblSettings
extends Properties {
    private static final long serialVersionUID = 6417122703384246759L;

    public RblSettings() {
        this.setProperty("rbl.domain", "rbl.localnet");
        this.setProperty("rbl.port", "15353");
        this.setProperty("rbl.address", "127.0.0.1");
        this.setProperty("rbl.admin.port", "15354");
        this.setProperty("rbl.file", "/var/lib/jwall-rbld/local.rbl");
        this.setProperty("rbl.permission.file", "/etc/jwall-rbld.permissions");
    }

    public static RblSettings getDefaults() {
        return new RblSettings();
    }

    public static RblSettings read(String file) throws Exception {
        RblSettings p = new RblSettings();
        File config = new File(file);
        if (config.isFile() && config.canRead()) {
            try {
                Properties cfg = new Properties();
                cfg.load(new FileInputStream(config));
                for (Object k : cfg.keySet()) {
                    p.setProperty(k.toString(), cfg.getProperty(k.toString()));
                }
            }
            catch (Exception e) {
                throw new Exception("Failed to read settings from '" + config.getAbsolutePath() + "': " + e.getMessage());
            }
        }
        for (String key : RblServer.PROPERTY_NAMES) {
            if (System.getProperty(key) == null || "".equals(System.getProperty(key).trim())) continue;
            p.setProperty(key, System.getProperty(key));
        }
        return p;
    }
}

