/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;

public class TimeFormat {
    public static final long SEC_MS = 1000L;
    public static final long MIN_MS = 60000L;
    public static final long HOUR_MS = 3600000L;
    public static final long DAY_MS = 86400000L;
    public static final long YEAR_MS = 31536000000L;
    static final NumberFormat fmt = null;
    static final long[] UNITS = new long[]{31536000000L, 86400000L, 3600000L, 60000L};
    static final String[] UNIT_NAME = new String[]{" year", " day", "h", "m"};

    public String format(long timeInMilliseconds) {
        long ms;
        long left = ms = timeInMilliseconds;
        long units = 0L;
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < UNITS.length; ++i) {
            long unit = UNITS[i];
            if (ms <= unit) continue;
            left = timeInMilliseconds % unit;
            units = (ms - left) / unit;
            s.append(units);
            s.append(UNIT_NAME[i]);
            if (units > 1L && i < 2) {
                s.append("s");
            }
            s.append(" ");
            ms = left;
        }
        double sec = (double)ms / 1000.0;
        if (s.length() == 0 || sec > 0.0) {
            s.append(sec);
            s.append("s");
        }
        return s.toString();
    }

    public String formatOld(long timeInMilliseconds) {
        long ms;
        long left = ms = timeInMilliseconds;
        long units = 0L;
        StringBuilder s = new StringBuilder();
        if (ms > 31536000000L) {
            left = timeInMilliseconds % 31536000000L;
            units = (ms - left) / 31536000000L;
            s.append(units);
            if (units > 1L) {
                s.append(" years ");
            } else {
                s.append(" year ");
            }
            ms = left;
        }
        if (ms > 86400000L) {
            left = timeInMilliseconds % 86400000L;
            units = (ms - left) / 86400000L;
            s.append(units);
            if (units > 1L) {
                s.append(" days ");
            } else {
                s.append(" day ");
            }
            ms = left;
        }
        if (ms > 3600000L) {
            left = ms % 3600000L;
            units = (ms - left) / 3600000L;
            s.append(units);
            s.append("h ");
            ms = left;
        }
        if (ms > 60000L) {
            left = ms % 60000L;
            units = (ms - left) / 60000L;
            s.append(units);
            s.append("m ");
            ms = left;
        }
        if (ms > 0L) {
            double d = (double)ms / 1000.0;
            if (fmt != null) {
                s.append(fmt.format(d));
            } else {
                s.append(d);
            }
            s.append("s");
        }
        return s.toString();
    }

    public static void main(String[] args) throws Exception {
        long last = 1232736401000L;
        System.out.println("last TS is " + last);
        System.out.println("cur TS is  " + System.currentTimeMillis());
        System.out.println("last = " + new Date(last));
        long start = System.currentTimeMillis();
        TimeFormat fmt = new TimeFormat();
        fmt.format(start);
        double fmtNewTime = 0.0;
        double fmtOldTime = 0.0;
        double cnt = 0.0;
        int fmtNewQuicker = 0;
        int fmtEquals = 0;
        int fmtquicker = 0;
        for (int i = 0; i < 1000000; ++i) {
            long now = System.currentTimeMillis();
            String s1 = "";
            String s2 = "";
            long fs = System.nanoTime();
            s1 = fmt.format(now);
            long fe = System.nanoTime();
            long fmtNew_took = fe - fs;
            fmtNewTime += (double)fmtNew_took;
            fs = System.nanoTime();
            s2 = fmt.formatOld(now);
            fe = System.nanoTime();
            long fmtOld_took = fe - fs;
            fmtOldTime += (double)fmtOld_took;
            cnt += 1.0;
            if (fmtNew_took < fmtOld_took) {
                ++fmtNewQuicker;
            } else if (fmtOld_took == fmtNew_took) {
                ++fmtEquals;
            } else {
                ++fmtquicker;
            }
            if (s1.equals(s2)) continue;
            System.out.println("Formatted string differed: s1='" + s1 + "', s2='" + s2 + "'");
            break;
        }
        System.out.println("Typical format: " + fmt.format(System.currentTimeMillis() - start));
        System.out.println("FormattingNew took " + fmtNewTime / cnt + "ns on average.");
        System.out.println("FormattingOld took " + fmtOldTime / cnt + "ns on average.");
        DecimalFormat dfmt = new DecimalFormat("0.00");
        double pct = fmtquicker;
        System.out.println("formatNew was quicker in " + fmtquicker + " attempts (" + dfmt.format(100.0 * (pct /= cnt)) + "%)");
        pct = fmtNewQuicker;
        System.out.println("formatOld was quicker in " + fmtNewQuicker + " attempts (" + dfmt.format(100.0 * (pct /= cnt)) + "%)");
        System.out.println("equal times needed in " + fmtEquals + " attempts.");
    }
}

