/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.rbl.dns;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.jwall.util.PropertyReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RblSecurityManager {
    static Logger log = LoggerFactory.getLogger(RblSecurityManager.class);
    private static final RblSecurityManager globalInstance = new RblSecurityManager();
    public static final String BLOCK_PERMISSION = "block";
    public static final String UNBLOCK_PERMISSION = "unblock";
    public static final String ALL_PERMISSION = "*";
    public static final String[] PERMISSIONS = new String[]{"block", "unblock"};
    Map<String, Set<String>> permissions = new LinkedHashMap<String, Set<String>>();

    private RblSecurityManager() {
        log.debug("Initializing SecurityManager");
    }

    public static RblSecurityManager getInstance() {
        return globalInstance;
    }

    public void readPermissions(File file) throws Exception {
        log.info("Reading permissions from file {}", (Object)file.getAbsolutePath());
        if (!file.canRead()) {
            throw new Exception("Cannot open file '" + file.getAbsolutePath() + "' for reading!");
        }
        this.readPermissions(new FileInputStream(file));
    }

    public void readPermissions(InputStream inputStream) throws Exception {
        this.permissions = new LinkedHashMap<String, Set<String>>();
        Properties p = PropertyReader.read(inputStream);
        for (Object k : p.keySet()) {
            String key = k.toString();
            if ("".equals(key.trim())) {
                log.info("Skipping key '{}'", (Object)key);
                continue;
            }
            log.info("Parsing address from '{}'", (Object)key);
            InetAddress addr = InetAddress.getByName(key);
            log.info("Address is: {} (toString: {})", (Object)addr.getHostAddress(), (Object)addr.toString());
            String[] ps = p.getProperty(key).split(",");
            TreeSet<String> perms = new TreeSet<String>();
            for (String perm : ps) {
                if (ALL_PERMISSION.equals(perm)) {
                    for (String permission : PERMISSIONS) {
                        perms.add(permission);
                    }
                    continue;
                }
                if (!this.isPermission(perm.toLowerCase())) continue;
                perms.add(perm.toLowerCase());
            }
            log.debug("   Adding permissions {} for address {}", perms, (Object)addr.getHostAddress());
            this.permissions.put(addr.getHostAddress(), perms);
        }
    }

    public boolean hasPermission(InetAddress addr, String perm) {
        log.debug("Checking permission {} for address {}", (Object)perm, (Object)addr.getHostAddress());
        Set<String> perms = this.permissions.get(addr.getHostAddress());
        log.debug("   permissions stored for {} are: {}", (Object)addr.getHostAddress(), perms);
        if (perms == null) {
            return false;
        }
        return perms.contains(perm);
    }

    private boolean isPermission(String perm) {
        for (String p : PERMISSIONS) {
            if (!p.equalsIgnoreCase(perm)) continue;
            return true;
        }
        return false;
    }
}

