/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.rbl.dns;

import java.util.ArrayList;
import java.util.List;
import org.jwall.rbl.dns.QuerySection;

public class Query {
    int id = 0;
    int flags = 0;
    int qcount = 0;
    int acount = 0;
    int arCount = 0;
    int nsCount = 0;
    ArrayList<QuerySection> sections = new ArrayList();

    private Query(int id) {
        this();
        this.id = id;
    }

    private Query() {
    }

    public int getId() {
        return this.id;
    }

    public Integer getFlags() {
        return this.flags;
    }

    public Integer getARCount() {
        return this.arCount;
    }

    public Integer getNSCount() {
        return this.nsCount;
    }

    public int getNumberOfSections() {
        return this.sections.size();
    }

    public Integer getQCount() {
        return this.qcount;
    }

    public Integer getACount() {
        return this.acount;
    }

    public List<QuerySection> getSections() {
        return new ArrayList<QuerySection>(this.sections);
    }

    public static Query parse(byte[] buf, int offset) throws Exception {
        char id;
        Query q = new Query();
        int ptr = offset;
        int firstByte = 0xFF & buf[ptr++];
        int secondByte = 0xFF & buf[ptr++];
        char qid = id = (char)(firstByte << 8 | secondByte);
        q.id = qid;
        q.flags = 0 + (buf[ptr++] << 8) + buf[ptr++];
        q.qcount = 0 + (buf[ptr++] << 8) + buf[ptr++];
        q.acount = 0 + (buf[ptr++] << 8) + buf[ptr++];
        q.nsCount = 0 + (buf[ptr++] << 8) + buf[ptr++];
        for (int i = 0; i < q.qcount; ++i) {
            QuerySection qsect = QuerySection.read(buf, offset + 12);
            q.sections.add(qsect);
        }
        return q;
    }
}

