/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.util;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class MultiSet<E>
implements Serializable {
    public static final long serialVersionUID = 26L;
    private Hashtable<E, Long> table = new Hashtable();
    private int total = 0;

    public void add(E key) {
        if (this.table.get(key) == null) {
            this.table.put(key, new Long(1L));
        } else {
            Long l = this.table.get(key);
            Long l2 = new Long(l + 1L);
            this.table.remove(key);
            this.table.put(key, l2);
        }
        ++this.total;
    }

    public Long getCount(E key) {
        if (this.table.get(key) == null) {
            return new Long(0L);
        }
        return this.table.get(key);
    }

    public E remove(E o) {
        if (this.table.get(o) == null) {
            return null;
        }
        Long c = this.table.get(o);
        Long l = new Long(c - 1L);
        if (l == 0L) {
            this.table.remove(o);
        } else {
            this.table.remove(o);
            this.table.put(o, l);
        }
        return o;
    }

    public E removeAll(E o) {
        if (this.table.get(o) == null) {
            return null;
        }
        this.table.remove(o);
        return o;
    }

    public double getPercentage(E key) {
        Long l = this.getCount(key);
        if (l > 0L) {
            return l.doubleValue() / (double)this.total;
        }
        return 0.0;
    }

    public Set<E> getValues() {
        TreeSet<E> s = new TreeSet<E>();
        for (E el : this.table.keySet()) {
            if (this.table.get(el) == null || this.table.get(el) <= 0L) continue;
            s.add(el);
        }
        return s;
    }

    public Long getTotal() {
        return new Long(this.total);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{ ");
        Iterator<E> it = this.getValues().iterator();
        while (it.hasNext()) {
            E key = it.next();
            sb.append("\"" + key + "\" (" + this.getCount(key) + ")");
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(" }");
        return sb.toString();
    }

    public boolean hasValue(E v) {
        return this.table.get(v) != null && this.table.get(v) > 0L;
    }

    public Iterator<E> iterator() {
        return this.getValues().iterator();
    }

    public int size() {
        return this.total;
    }

    public int distinctSize() {
        return this.table.values().size();
    }

    public void clear() {
        this.table.clear();
        this.total = 0;
    }

    public void addCount(E key, Long c) {
        Long count = 0L;
        if (this.table.get(key) != null) {
            count = this.table.remove(key);
        }
        this.table.put(key, count + c);
    }
}

