/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.rbl.dns;

import java.nio.ByteBuffer;
import org.jwall.rbl.dns.DNSParser;

public class ResourceRecord {
    public static final int TYPE_A = 1;
    public static final byte[] TYPE_NS = new byte[]{0, 1};
    public static final byte TYPE_CNAME = 5;
    public static final byte TYPE_SOA = 6;
    public static final byte TYPE_PTR = 12;
    public static final byte TYPE_MX = 15;
    public static final byte TYPE_TXT = 16;
    public static final int RCLASS_IN = 1;
    byte[] value;
    int rtype = 1;
    int rclass = 1;
    int ttl = 0;
    byte[] rdata = new byte[0];

    protected ResourceRecord(String value, int type, int ttl) {
        this.value = DNSParser.toByteArray(value);
        this.rtype = type;
        this.ttl = ttl;
    }

    public int length() {
        return this.value.length + 2 + 2 + 4 + 2 + this.rdata.length;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.length()];
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.put(this.value);
        buf.put((byte)((this.rtype & 0xFF00) >> 8));
        buf.put((byte)(this.rtype & 0xFF));
        buf.put((byte)((this.rclass & 0xFF00) >> 8));
        buf.put((byte)(this.rclass & 0xFF));
        buf.putInt(this.ttl);
        int rdlength = this.rdata.length;
        buf.put((byte)((rdlength & 0xFF00) >> 8));
        buf.put((byte)(rdlength & 0xFF));
        buf.put(this.rdata);
        return data;
    }
}

