/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.rbl.dns;

import java.nio.ByteBuffer;
import java.util.ArrayList;

public class DNSParser {
    public static String[] readDNSstring(ByteBuffer buf) {
        return DNSParser.readDNSstring(buf.array());
    }

    public static String[] readDNSstring(byte[] buf) {
        ArrayList<String> parts = new ArrayList<String>();
        int ptr = 0;
        byte len = buf[ptr++];
        while (len > 0) {
            StringBuffer s = new StringBuffer();
            for (byte i = 0; i < len; i = (byte)(i + 1)) {
                s.append((char)buf[ptr++]);
            }
            parts.add(s.toString());
            len = buf[ptr++];
        }
        String[] result = new String[parts.size()];
        parts.toArray(result);
        return result;
    }

    public static String printDNSstring(String[] str) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < str.length; ++i) {
            s.append(str[i]);
            if (i + 1 >= str.length) continue;
            s.append(".");
        }
        return s.toString();
    }

    public static ByteBuffer toDNSdata(String str) {
        return DNSParser.toDNSdata(str.split("\\."));
    }

    public static byte[] toByteArray(String str) {
        return DNSParser.toByteArray(str.split("\\."));
    }

    public static byte[] toByteArray(String[] str) {
        int size = 1;
        for (String s : str) {
            size += s.length();
        }
        byte[] buf = new byte[size + str.length];
        int ptr = 0;
        for (String s : str) {
            buf[ptr++] = (byte)s.length();
            for (int i = 0; i < s.length(); ++i) {
                buf[ptr++] = (byte)s.charAt(i);
            }
        }
        buf[ptr] = 0;
        return buf;
    }

    public static ByteBuffer toDNSdata(String[] str) {
        int size = 1;
        for (String s : str) {
            size += s.length();
        }
        ByteBuffer buf = ByteBuffer.allocate(size);
        for (String s : str) {
            buf.put((byte)s.length());
            for (int i = 0; i < s.length(); ++i) {
                buf.put((byte)s.charAt(i));
            }
        }
        buf.put((byte)0);
        buf.flip();
        return buf;
    }
}

