/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl.maven;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.writer.FileCodeWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jvnet.ws.wadl2java.Wadl2Java;

public class Wadl2JavaMojo
extends AbstractMojo {
    private String generationStyle = "jersey1x";
    private String packageName;
    private File targetDirectory;
    private File sourceDirectory;
    private URL[] targets;
    private String includes;
    private List<String> customizations;
    private MavenProject project;
    private boolean autoPackaging = true;
    private Properties customClassNames;
    private boolean failOnError = true;
    private List<String> xjcArguments = new ArrayList<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.doExecute(this.failOnError ? new FailOnErrorPolicy() : new LogOnlyErrorPolicy());
    }

    private void doExecute(ErrorPolicy policy) throws MojoExecutionException {
        ArrayList<URI> toProcess = new ArrayList<URI>();
        if (this.sourceDirectory != null && this.sourceDirectory.exists() && this.sourceDirectory.canRead()) {
            String[] matches = this.getWadlFileMatches();
            for (int i = matches.length - 1; i >= 0; --i) {
                File file = new File(this.sourceDirectory, matches[i]);
                toProcess.add(file.toURI());
            }
        }
        if (this.targets != null) {
            for (URL target : this.targets) {
                try {
                    toProcess.add(target.toURI());
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(Wadl2JavaMojo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        try {
            this.assureTargetDirExistence();
            Wadl2Java processor = this.createProcessor();
            for (URI next : toProcess) {
                try {
                    processor.process(next);
                }
                catch (JClassAlreadyExistsException jcae) {
                    policy.process(jcae.getExistingClass().fullName() + " already exists.", jcae);
                }
                catch (Exception e) {
                    policy.process("Failed to generate sources from " + next.toASCIIString() + ".", e);
                    throw new MojoExecutionException(e.getMessage(), e);
                }
            }
            this.project.addCompileSourceRoot(this.targetDirectory.getAbsolutePath());
        }
        catch (IOException ioe) {
            policy.process("Unexpected exception creating processor", ioe);
        }
    }

    private String[] getWadlFileMatches() {
        String[] patterns = this.includes.split(",");
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.sourceDirectory);
        scanner.setIncludes(patterns);
        scanner.scan();
        String[] matches = scanner.getIncludedFiles();
        return matches;
    }

    private Wadl2Java createProcessor() throws IOException {
        ArrayList<File> customizationFiles = null;
        if (this.customizations != null) {
            customizationFiles = new ArrayList<File>(this.customizations.size());
            for (String customization : this.customizations) {
                customizationFiles.add(new File(customization));
            }
        } else {
            customizationFiles = Collections.EMPTY_LIST;
        }
        if (this.customClassNames == null) {
            this.customClassNames = new Properties();
        }
        HashMap<String, String> customClassNamesMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.customClassNames.entrySet()) {
            customClassNamesMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        Wadl2Java.Parameters parameters = new Wadl2Java.Parameters();
        parameters.setAutoPackage(this.autoPackaging);
        parameters.setCustomClassNames(customClassNamesMap);
        parameters.setCustomizationsAsFiles(customizationFiles);
        parameters.setPkg(this.packageName);
        parameters.setRootDir(this.targetDirectory.toURI());
        parameters.setCodeWriter((CodeWriter)new FileCodeWriter(this.targetDirectory));
        parameters.setXjcArguments(this.xjcArguments);
        parameters.setGenerationStyle(this.generationStyle);
        Wadl2Java processor = new Wadl2Java(parameters);
        return processor;
    }

    private void assureTargetDirExistence() throws MojoExecutionException {
        if (!this.targetDirectory.exists() && !this.targetDirectory.mkdirs()) {
            throw new MojoExecutionException("Failed to create " + this.targetDirectory.getAbsolutePath());
        }
    }

    private class LogOnlyErrorPolicy
    implements ErrorPolicy {
        private LogOnlyErrorPolicy() {
        }

        @Override
        public void process(String message, Throwable cause) throws MojoExecutionException {
            Wadl2JavaMojo.this.getLog().error((CharSequence)message, cause);
        }
    }

    private class FailOnErrorPolicy
    implements ErrorPolicy {
        private FailOnErrorPolicy() {
        }

        @Override
        public void process(String message, Throwable cause) throws MojoExecutionException {
            throw new MojoExecutionException(message, cause);
        }
    }

    private static interface ErrorPolicy {
        public void process(String var1, Throwable var2) throws MojoExecutionException;
    }
}

