/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.localizer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;
import org.jvnet.localizer.ClassGenerator;
import org.jvnet.localizer.GeneratorConfig;
import org.jvnet.localizer.Reporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratorBase
implements ClassGenerator {
    protected final File outputDirectory;
    protected final String outputEncoding;
    protected final Reporter reporter;
    protected final Pattern keyPattern;
    protected final boolean strictTypes;
    protected final boolean accessModifierAnnotations;

    public GeneratorBase(GeneratorConfig config) {
        this.outputDirectory = config.getOutputDirectory();
        this.outputEncoding = config.getOutputEncoding();
        this.reporter = config.getReporter();
        this.keyPattern = config.getKeyPattern();
        this.strictTypes = config.isStrictTypes();
        this.accessModifierAnnotations = config.isAccessModifierAnnotations();
    }

    @Override
    public void generate(File baseDir, DirectoryScanner ds, FileFilter filter) throws IOException {
        if (filter == null) {
            this.generate(baseDir, ds);
            return;
        }
        for (String relPath : ds.getIncludedFiles()) {
            File f = new File(baseDir, relPath);
            if (!filter.accept(f)) continue;
            try {
                this.generate(f, relPath);
            }
            catch (IOException e) {
                IOException x = new IOException("Failed to generate a class from " + f);
                x.initCause(e);
                throw x;
            }
        }
    }

    @Override
    public void generate(File baseDir, DirectoryScanner ds) throws IOException {
        this.generate(baseDir, ds, new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(".properties") && !f.getName().contains("_");
            }
        });
    }

    @Override
    public void generate(File propertyFile, String relPath) throws IOException {
        String className = this.toClassName(relPath);
        File sourceFile = new File(this.outputDirectory, className.replace('.', '/') + ".java");
        if (sourceFile.exists() && sourceFile.lastModified() > propertyFile.lastModified()) {
            this.reporter.debug(sourceFile + " is up to date");
            return;
        }
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(propertyFile);
        try {
            props.load(in);
        }
        catch (IOException e) {
            in.close();
        }
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String key = e.getKey().toString();
            this.assertKeyPatternMatched(key);
        }
        this.generateImpl(className, props);
    }

    protected abstract void generateImpl(String var1, Properties var2);

    protected String toClassName(String relPath) {
        relPath = relPath.substring(0, relPath.length() - ".properties".length());
        return relPath.replace(File.separatorChar, '.');
    }

    protected String toJavaIdentifier(String key) {
        return key.replace('.', '_').replace('-', '_').replace('/', '_');
    }

    protected void assertKeyPatternMatched(String key) {
        if (this.keyPattern != null && !this.keyPattern.matcher(key).matches()) {
            String message = String.format("Key \"%1$s\" does not match specified keyPattern \"%2$s\".", key, this.keyPattern);
            throw new IllegalArgumentException(message);
        }
    }

    protected Class<?> inferType(Format format) {
        if (this.strictTypes) {
            if (format instanceof DateFormat) {
                return Date.class;
            }
            if (format instanceof NumberFormat) {
                return Number.class;
            }
        }
        return Object.class;
    }

    protected int countArgs(String formatString) {
        return new MessageFormat(formatString).getFormatsByArgumentIndex().length;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected String getOutputEncoding() {
        return this.outputEncoding;
    }

    protected Reporter getReporter() {
        return this.reporter;
    }

    protected Pattern getKeyPattern() {
        return this.keyPattern;
    }
}

