/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.localizer;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.File;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.text.WordUtils;
import org.jvnet.localizer.ClassGenerator;
import org.jvnet.localizer.CodeModelGenerator;
import org.jvnet.localizer.GeneratorConfig;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.Reporter;
import org.jvnet.localizer.ResourceBundleHolder;

public class Generator
extends CodeModelGenerator
implements ClassGenerator {
    public Generator(GeneratorConfig config) {
        super(config);
    }

    @Deprecated
    public Generator(File outputDirectory, Reporter reporter) {
        this(outputDirectory, null, reporter);
    }

    @Deprecated
    public Generator(File outputDirectory, String outputEncoding, Reporter reporter) {
        this(outputDirectory, null, reporter, null);
    }

    @Deprecated
    public Generator(File outputDirectory, String outputEncoding, Reporter reporter, String keyPattern) {
        this(GeneratorConfig.of(outputDirectory, outputEncoding, reporter, keyPattern));
    }

    protected void generateImpl(String className, Properties props) throws AssertionError {
        try {
            JDefinedClass c = this.cm._class(className);
            c.annotate(SuppressWarnings.class).paramArray("value").param("").param("PMD").param("all");
            c.javadoc().add((Object)"Generated localization support class.");
            JFieldVar holder = c.field(28, ResourceBundleHolder.class, "holder", (JExpression)this.cm.ref(ResourceBundleHolder.class).staticInvoke("get").arg(c.dotclass()));
            holder.javadoc().add((Object)"The resource bundle reference");
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                String key = e.getKey().toString();
                String value = e.getValue().toString();
                Format[] formats = new MessageFormat(value).getFormatsByArgumentIndex();
                HashMap<String, String> params = new HashMap<String, String>();
                ArrayList<JVar> args = new ArrayList<JVar>();
                JMethod m = c.method(17, (JType)this.cm.ref(String.class), this.toJavaIdentifier(key));
                for (int i = 0; i < formats.length; ++i) {
                    String argName = String.format("arg%d", i);
                    args.add(m.param(this.inferType(formats[i]), argName));
                    if (formats[i] instanceof NumberFormat) {
                        params.put(argName, String.format("%s format parameter, {@code {%d}}, a number.", this.positionalName(i), i));
                        continue;
                    }
                    if (formats[i] instanceof DateFormat) {
                        params.put(argName, String.format("%s format parameter, {@code {%d}}, a {@link java.util.Date}.", this.positionalName(i), i));
                        continue;
                    }
                    params.put(argName, String.format("%s format parameter, {@code {%d}}, as {@link String#valueOf(Object)}.", this.positionalName(i), i));
                }
                JInvocation inv = holder.invoke("format").arg(key);
                for (JVar jVar : args) {
                    inv.arg((JExpression)jVar);
                }
                m.body()._return((JExpression)inv);
                m.javadoc().add((Object)WordUtils.wrap((String)String.format("Key %s: %s.", this.code(key), this.code(value)), (int)70));
                for (Map.Entry entry : params.entrySet()) {
                    m.javadoc().addParam((String)entry.getKey()).add(entry.getValue());
                }
                m.javadoc().addReturn().add((Object)WordUtils.wrap((String)this.code(value), (int)70));
                args.clear();
                params.clear();
                m = c.method(17, (JType)this.cm.ref(Localizable.class), '_' + this.toJavaIdentifier(key));
                for (int i = 0; i < formats.length; ++i) {
                    String string = String.format("arg%d", i);
                    args.add(m.param(this.inferType(formats[i]), string));
                    if (formats[i] instanceof NumberFormat) {
                        params.put(string, String.format("%s format parameter, {@code {%d}}, a number.", this.positionalName(i), i));
                        continue;
                    }
                    if (formats[i] instanceof DateFormat) {
                        params.put(string, String.format("%s format parameter, {@code {%d}}, a {@link java.util.Date}.", this.positionalName(i), i));
                        continue;
                    }
                    params.put(string, String.format("%s format parameter, {@code {%d}}, as {@link String#valueOf(Object)}.", this.positionalName(i), i));
                }
                inv = JExpr._new((JClass)this.cm.ref(Localizable.class)).arg((JExpression)holder).arg(key);
                for (JVar jVar : args) {
                    inv.arg((JExpression)jVar);
                }
                m.body()._return((JExpression)inv);
                m.javadoc().add((Object)WordUtils.wrap((String)String.format("Key %s: %s.", this.code(key), this.code(value)), (int)70));
                for (Map.Entry entry : params.entrySet()) {
                    m.javadoc().addParam((String)entry.getKey()).add(entry.getValue());
                }
                m.javadoc().addReturn().add((Object)WordUtils.wrap((String)this.code(value), (int)70));
            }
        }
        catch (JClassAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    private String code(String value) {
        return String.format("{@code %s}", value);
    }

    private String escape(String value) {
        return value.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private String positionalName(int i) {
        if (i % 100 >= 9 && i % 100 < 20) {
            return String.format("%dth", i + 1);
        }
        switch (i % 10) {
            case 0: {
                return String.format("%dst", i + 1);
            }
            case 1: {
                return String.format("%dnd", i + 1);
            }
            case 2: {
                return String.format("%drd", i + 1);
            }
        }
        return String.format("%dth", i + 1);
    }
}

