/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.util;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.FieldAccessor;
import com.sun.tools.xjc.outline.FieldOutline;

public class FieldAccessorFactory {
    private FieldAccessorFactory() {
    }

    public static FieldAccessor createFieldAccessor(FieldOutline fieldOutline, JExpression targetObject) {
        return new PropertyFieldAccessor(fieldOutline, targetObject);
    }

    private static class PropertyFieldAccessor
    implements FieldAccessor {
        private static final JType[] ABSENT = new JType[0];
        private final FieldOutline fieldOutline;
        private final JExpression targetObject;
        private final JMethod isSetter;
        private final JMethod unSetter;
        private final JMethod getter;
        private final JMethod setter;
        private FieldAccessor fieldAccessor;

        public PropertyFieldAccessor(FieldOutline fieldOutline, JExpression targetObject) {
            this.fieldOutline = fieldOutline;
            this.targetObject = targetObject;
            this.fieldAccessor = fieldOutline.create(targetObject);
            String publicName = fieldOutline.getPropertyInfo().getName(true);
            JDefinedClass theClass = fieldOutline.parent().implClass;
            String getterName = "get" + publicName;
            String setterName = "set" + publicName;
            this.getter = theClass.getMethod(getterName, ABSENT);
            JType rawType = fieldOutline.getRawType();
            JMethod boxifiedSetter = theClass.getMethod(setterName, new JType[]{rawType.boxify()});
            JMethod unboxifiedSetter = theClass.getMethod(setterName, new JType[]{rawType.unboxify()});
            this.setter = boxifiedSetter != null ? boxifiedSetter : unboxifiedSetter;
            this.isSetter = theClass.getMethod("isSet" + publicName, ABSENT);
            this.unSetter = theClass.getMethod("unset" + publicName, ABSENT);
        }

        public FieldOutline owner() {
            return this.fieldOutline;
        }

        public CPropertyInfo getPropertyInfo() {
            return this.fieldOutline.getPropertyInfo();
        }

        public JExpression hasSetValue() {
            if (this.isSetter != null) {
                return this.targetObject.invoke(this.isSetter);
            }
            return this.fieldAccessor.hasSetValue();
        }

        public void unsetValues(JBlock body) {
            if (this.unSetter != null) {
                body.invoke(this.targetObject, this.unSetter);
            } else {
                this.fieldAccessor.unsetValues(body);
            }
        }

        public void fromRawValue(JBlock block, String uniqueName, JExpression $var) {
            if (this.setter != null) {
                block.invoke(this.targetObject, this.setter).arg($var);
            } else {
                this.unsetValues(block);
                this.fieldAccessor.fromRawValue(block, uniqueName, $var);
            }
        }

        public void toRawValue(JBlock block, JVar $var) {
            if (this.getter != null) {
                block.assign((JAssignmentTarget)$var, (JExpression)this.targetObject.invoke(this.getter));
            } else {
                this.fieldAccessor.toRawValue(block, $var);
            }
        }
    }
}

