/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.lang;

import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

public class DefaultHashCodeStrategy
implements HashCodeStrategy {
    private int iConstant;
    public static final HashCodeStrategy INSTANCE = new DefaultHashCodeStrategy();

    public DefaultHashCodeStrategy() {
        this.iConstant = 37;
    }

    public DefaultHashCodeStrategy(int multiplierNonZeroOddNumber) {
        if (multiplierNonZeroOddNumber == 0) {
            throw new IllegalArgumentException("HashCodeStrategy requires a non zero multiplier.");
        }
        if (multiplierNonZeroOddNumber % 2 == 0) {
            throw new IllegalArgumentException("HashCodeStrategy requires an odd multiplier.");
        }
        this.iConstant = multiplierNonZeroOddNumber;
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, Object object) {
        if (object == null) {
            return hashCode * this.iConstant;
        }
        if (!object.getClass().isArray()) {
            return this.hashCodeInternal(locator, hashCode, object);
        }
        if (object instanceof long[]) {
            return this.hashCode(locator, hashCode, (long[])object);
        }
        if (object instanceof int[]) {
            return this.hashCode(locator, hashCode, (int[])object);
        }
        if (object instanceof short[]) {
            return this.hashCode(locator, hashCode, (short[])object);
        }
        if (object instanceof char[]) {
            return this.hashCode(locator, hashCode, (char[])object);
        }
        if (object instanceof byte[]) {
            return this.hashCode(locator, hashCode, (byte[])object);
        }
        if (object instanceof double[]) {
            return this.hashCode(locator, hashCode, (double[])object);
        }
        if (object instanceof float[]) {
            return this.hashCode(locator, hashCode, (float[])object);
        }
        if (object instanceof boolean[]) {
            return this.hashCode(locator, hashCode, (boolean[])object);
        }
        if (object instanceof HashCode[]) {
            return this.hashCodeInternal(locator, hashCode, (HashCode[])object);
        }
        if (object instanceof Enum[]) {
            return this.hashCodeInternal(locator, hashCode, (Enum[])object);
        }
        return this.hashCode(locator, hashCode, (Object[])object);
    }

    protected int hashCodeInternal(ObjectLocator locator, int hashCode, Object value) {
        if (value == null) {
            return hashCode * this.iConstant;
        }
        if (value instanceof HashCode) {
            return this.hashCodeInternal(locator, hashCode, (HashCode)value);
        }
        if (value instanceof Enum) {
            return this.hashCodeInternal(locator, hashCode, (Enum)value);
        }
        return hashCode * this.iConstant + value.hashCode();
    }

    protected int hashCodeInternal(ObjectLocator locator, int hashCode, Enum<?> value) {
        if (value == null) {
            return hashCode * this.iConstant;
        }
        if (value instanceof HashCode) {
            return this.hashCodeInternal(locator, hashCode, (HashCode)((Object)value));
        }
        return hashCode * this.iConstant + value.hashCode();
    }

    protected int hashCodeInternal(ObjectLocator locator, int hashCode, HashCode object) {
        if (object == null) {
            return hashCode * this.iConstant;
        }
        return hashCode * this.iConstant + object.hashCode(locator, this);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, Object[] value) {
        if (value == null) {
            return hashCode * this.iConstant;
        }
        int currentHashCode = hashCode * this.iConstant + 1;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return currentHashCode;
    }

    protected int hashCodeInternal(ObjectLocator locator, int hashCode, Enum<?>[] value) {
        if (value == null) {
            return hashCode * this.iConstant;
        }
        int currentHashCode = hashCode * this.iConstant + 1;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCodeInternal((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return currentHashCode;
    }

    protected int hashCodeInternal(ObjectLocator locator, int hashCode, HashCode[] value) {
        if (value == null) {
            return hashCode * this.iConstant;
        }
        int currentHashCode = hashCode * this.iConstant + 1;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCodeInternal((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return currentHashCode;
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, boolean value) {
        return hashCode * this.iConstant + (value ? 0 : 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, byte value) {
        return hashCode * this.iConstant + value;
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, char value) {
        return hashCode * this.iConstant + value;
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, double value) {
        return this.hashCode(locator, hashCode, Double.doubleToLongBits(value));
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, float value) {
        return this.hashCode(locator, hashCode, Float.floatToIntBits(value));
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, int value) {
        return hashCode * this.iConstant + value;
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, long value) {
        return hashCode * this.iConstant + (int)(value ^ value >> 32);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, short value) {
        return hashCode * this.iConstant + value;
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, boolean[] value) {
        if (value == null) {
            return hashCode * this.iConstant;
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return currentHashCode;
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, byte[] value) {
        if (value == null) {
            return hashCode * this.iConstant;
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return currentHashCode;
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, char[] value) {
        if (value == null) {
            return hashCode * this.iConstant;
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return currentHashCode;
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, double[] value) {
        if (value == null) {
            return hashCode * this.iConstant;
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return currentHashCode;
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, float[] value) {
        if (value == null) {
            return hashCode * this.iConstant;
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return currentHashCode;
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, int[] value) {
        if (value == null) {
            return hashCode * this.iConstant;
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return currentHashCode;
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, long[] value) {
        if (value == null) {
            return hashCode * this.iConstant;
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return currentHashCode;
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, short[] value) {
        if (value == null) {
            return hashCode * this.iConstant;
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return currentHashCode;
    }
}

