/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.xml.bind.model.concrete;

import com.sun.xml.bind.v2.model.core.Adapter;
import com.sun.xml.bind.v2.model.core.AttributePropertyInfo;
import com.sun.xml.bind.v2.model.core.BuiltinLeafInfo;
import com.sun.xml.bind.v2.model.core.ClassInfo;
import com.sun.xml.bind.v2.model.core.Element;
import com.sun.xml.bind.v2.model.core.ElementInfo;
import com.sun.xml.bind.v2.model.core.ElementPropertyInfo;
import com.sun.xml.bind.v2.model.core.EnumConstant;
import com.sun.xml.bind.v2.model.core.EnumLeafInfo;
import com.sun.xml.bind.v2.model.core.ID;
import com.sun.xml.bind.v2.model.core.MapPropertyInfo;
import com.sun.xml.bind.v2.model.core.NonElement;
import com.sun.xml.bind.v2.model.core.PropertyInfo;
import com.sun.xml.bind.v2.model.core.ReferencePropertyInfo;
import com.sun.xml.bind.v2.model.core.TypeInfo;
import com.sun.xml.bind.v2.model.core.TypeInfoSet;
import com.sun.xml.bind.v2.model.core.TypeRef;
import com.sun.xml.bind.v2.model.core.ValuePropertyInfo;
import com.sun.xml.bind.v2.model.core.WildcardTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.MimeType;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.lang.Validate;
import org.jvnet.jaxb2_commons.xml.bind.model.MBuiltinLeafInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MContainer;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MEnumLeafInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MModelInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPackageInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMAnyAttributePropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMAnyElementPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMAttributePropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMBuiltinLeafInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMClassInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMElementInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMElementPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMElementRefPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMElementRefsPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMElementTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMElementsPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMEnumConstantInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMEnumLeafInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMID;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMIDREF;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMIDREFS;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMList;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMModel;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMValuePropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.CMWildcardTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.origin.CMAnyAttributePropertyInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.origin.CMBuiltinLeafInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.origin.CMClassInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.origin.CMElementInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.origin.CMEnumConstantInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.origin.CMEnumLeafInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.origin.CMModelInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.origin.CMPropertyInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.concrete.origin.CMWildcardTypeInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.origin.MBuiltinLeafInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.origin.MClassInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.origin.MElementInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.origin.MEnumConstantInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.origin.MEnumLeafInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.origin.MModelInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.origin.MPropertyInfoOrigin;
import org.jvnet.jaxb2_commons.xml.bind.model.origin.MWildcardTypeInfoOrigin;

public abstract class CMInfoFactory<T, C extends T, TIS extends TypeInfoSet<T, C, ?, ?>, TI extends TypeInfo<T, C>, BLI extends BuiltinLeafInfo<T, C>, EI extends ElementInfo<T, C>, ELI extends EnumLeafInfo<T, C>, EC extends EnumConstant<T, C>, CI extends ClassInfo<T, C>, PI extends PropertyInfo<T, C>, API extends AttributePropertyInfo<T, C>, VPI extends ValuePropertyInfo<T, C>, EPI extends ElementPropertyInfo<T, C>, RPI extends ReferencePropertyInfo<T, C>, WTI extends WildcardTypeInfo<T, C>> {
    private final Map<BLI, MBuiltinLeafInfo<T, C>> builtinLeafInfos = new IdentityHashMap<BLI, MBuiltinLeafInfo<T, C>>();
    private final Map<CI, MClassInfo<T, C>> classInfos = new IdentityHashMap<CI, MClassInfo<T, C>>();
    private final Map<ELI, MEnumLeafInfo<T, C>> enumLeafInfos = new IdentityHashMap<ELI, MEnumLeafInfo<T, C>>();
    private final Map<EI, MElementInfo<T, C>> elementInfos = new IdentityHashMap<EI, MElementInfo<T, C>>();
    private final TIS typeInfoSet;

    public CMInfoFactory(TIS typeInfoSet) {
        Validate.notNull(typeInfoSet);
        this.typeInfoSet = typeInfoSet;
    }

    public MModelInfo<T, C> createModel() {
        CMModel<T, C> model = new CMModel<T, C>(this.createModelInfoOrigin(this.typeInfoSet));
        Collection builtins = this.typeInfoSet.builtins().values();
        for (BuiltinLeafInfo builtinLeafInfo : builtins) {
            model.addBuiltinLeafInfo(this.getTypeInfo((BLI)builtinLeafInfo));
        }
        Collection beans = this.typeInfoSet.beans().values();
        for (ClassInfo classInfo : beans) {
            model.addClassInfo(this.getTypeInfo((CI)classInfo));
        }
        Collection enums = this.typeInfoSet.enums().values();
        for (EnumLeafInfo enumLeafInfo : enums) {
            model.addEnumLeafInfo(this.getTypeInfo((ELI)enumLeafInfo));
        }
        Iterable elements = this.typeInfoSet.getAllElements();
        for (ElementInfo element : elements) {
            model.addElementInfo(this.getElementInfo(element));
        }
        return model;
    }

    protected MTypeInfo<T, C> getTypeInfo(PropertyInfo<T, C> propertyInfo, TI typeInfo, boolean list, Adapter<T, C> adapter, ID id, MimeType mimeType) {
        MTypeInfo<T, C> ti = this.getTypeInfo((EI)typeInfo);
        if (list) {
            switch (id) {
                case ID: {
                    CMID<T, C> tid = new CMID<T, C>(ti.getTargetType(), ti);
                    return new CMList(this.createListType(tid.getTargetType()), tid);
                }
                case IDREF: {
                    return new CMIDREFS<T, C>(this.createListType(ti.getTargetType()), ti);
                }
            }
            return new CMList<T, C>(this.createListType(ti.getTargetType()), ti);
        }
        switch (id) {
            case ID: {
                return new CMID<T, C>(ti.getTargetType(), ti);
            }
            case IDREF: {
                return new CMIDREF<T, C>(ti.getTargetType(), ti);
            }
        }
        return ti;
    }

    protected MTypeInfo<T, C> getTypeInfo(TI typeInfo) {
        if (typeInfo instanceof BuiltinLeafInfo) {
            return this.getTypeInfo((BLI)((BuiltinLeafInfo)typeInfo));
        }
        if (typeInfo instanceof EnumLeafInfo) {
            return this.getTypeInfo((ELI)((EnumLeafInfo)typeInfo));
        }
        if (typeInfo instanceof ElementInfo) {
            return this.getTypeInfo((EI)((ElementInfo)typeInfo));
        }
        if (typeInfo instanceof WildcardTypeInfo) {
            return this.createWildcardTypeInfo((WildcardTypeInfo)typeInfo);
        }
        if (typeInfo instanceof ClassInfo) {
            return this.getTypeInfo((CI)((ClassInfo)typeInfo));
        }
        throw new UnsupportedOperationException(typeInfo.getClass().getName());
    }

    private MBuiltinLeafInfo<T, C> getTypeInfo(BLI typeInfo) {
        MBuiltinLeafInfo<T, C> builtinLeafInfo = this.builtinLeafInfos.get(typeInfo);
        if (builtinLeafInfo == null) {
            builtinLeafInfo = this.createBuiltinLeafInfo(typeInfo);
            this.builtinLeafInfos.put(typeInfo, builtinLeafInfo);
            return builtinLeafInfo;
        }
        return builtinLeafInfo;
    }

    private MTypeInfo<T, C> getTypeInfo(EI info) {
        ElementPropertyInfo p = info.getProperty();
        NonElement contentType = info.getContentType();
        return this.getTypeInfo((PropertyInfo<T, C>)p, (TI)contentType, p.isValueList(), (Adapter<T, C>)p.getAdapter(), p.id(), p.getExpectedMimeType());
    }

    protected MClassInfo<T, C> getTypeInfo(CI info) {
        MClassInfo<T, C> classInfo = this.classInfos.get(info);
        if (classInfo == null) {
            classInfo = this.createClassInfo(info);
            this.classInfos.put(info, classInfo);
            if (info.hasAttributeWildcard()) {
                classInfo.addProperty(this.createAnyAttributePropertyInfo(classInfo));
            }
            for (PropertyInfo p : info.getProperties()) {
                classInfo.addProperty(this.createPropertyInfo(classInfo, p));
            }
        }
        return classInfo;
    }

    private MEnumLeafInfo<T, C> getTypeInfo(ELI info) {
        MEnumLeafInfo<T, C> enumLeafInfo = this.enumLeafInfos.get(info);
        if (enumLeafInfo == null) {
            Iterable _constants;
            enumLeafInfo = this.createEnumLeafInfo(info);
            this.enumLeafInfos.put(info, enumLeafInfo);
            Iterable enumConstants = _constants = info.getConstants();
            for (EnumConstant enumConstant : enumConstants) {
                enumLeafInfo.addEnumConstantInfo(this.createEnumContantInfo(enumLeafInfo, enumConstant));
            }
        }
        return enumLeafInfo;
    }

    protected MElementInfo<T, C> getElementInfo(EI info) {
        MElementInfo<T, C> mElementInfo = this.elementInfos.get(info);
        if (mElementInfo == null) {
            mElementInfo = this.createElementInfo(info);
            this.elementInfos.put(info, mElementInfo);
        }
        return mElementInfo;
    }

    protected MClassInfo<T, C> createClassInfo(CI info) {
        return new CMClassInfo<T, Object>(this.createClassInfoOrigin(info), info.getClazz(), this.getPackage((EI)info), this.getContainer((ELI)info), this.getLocalName((EI)info), this.createBaseTypeInfo(info), info.isElement() ? info.getElementName() : null);
    }

    protected MClassTypeInfo<T, C> createBaseTypeInfo(CI info) {
        return info.getBaseClass() == null ? null : this.getTypeInfo((CI)info.getBaseClass());
    }

    private MPropertyInfo<T, C> createPropertyInfo(MClassInfo<T, C> classInfo, PI p) {
        if (p instanceof AttributePropertyInfo) {
            AttributePropertyInfo api = (AttributePropertyInfo)p;
            return this.createAttributePropertyInfo(classInfo, api);
        }
        if (p instanceof ValuePropertyInfo) {
            ValuePropertyInfo vpi = (ValuePropertyInfo)p;
            return this.createValuePropertyInfo(classInfo, vpi);
        }
        if (p instanceof ElementPropertyInfo) {
            ElementPropertyInfo ep = (ElementPropertyInfo)p;
            if (ep.getTypes().size() == 1) {
                return this.createElementPropertyInfo(classInfo, ep);
            }
            return this.createElementsPropertyInfo(classInfo, ep);
        }
        if (p instanceof ReferencePropertyInfo) {
            ReferencePropertyInfo rp = (ReferencePropertyInfo)p;
            Set elements = rp.getElements();
            if (elements.size() == 0 && rp.getWildcard() != null && (rp.getWildcard().allowDom || rp.getWildcard().allowTypedObject)) {
                return this.createAnyElementPropertyInfo(classInfo, rp);
            }
            if (elements.size() == 1) {
                return this.createElementRefPropertyInfo(classInfo, rp);
            }
            return this.createElementRefsPropertyInfo(classInfo, rp);
        }
        if (p instanceof MapPropertyInfo) {
            throw new UnsupportedOperationException();
        }
        throw new AssertionError();
    }

    protected MPropertyInfo<T, C> createAttributePropertyInfo(MClassInfo<T, C> classInfo, API propertyInfo) {
        return new CMAttributePropertyInfo<T, C>(this.createPropertyInfoOrigin(propertyInfo), classInfo, propertyInfo.getName(), this.getTypeInfo((AttributePropertyInfo<T, C>)propertyInfo), propertyInfo.getXmlName());
    }

    protected MPropertyInfo<T, C> createValuePropertyInfo(MClassInfo<T, C> classInfo, VPI propertyInfo) {
        return new CMValuePropertyInfo<T, C>(this.createPropertyInfoOrigin(propertyInfo), classInfo, propertyInfo.getName(), this.getTypeInfo((ValuePropertyInfo<T, C>)propertyInfo));
    }

    protected MPropertyInfo<T, C> createElementPropertyInfo(MClassInfo<T, C> classInfo, EPI ep) {
        TypeRef typeRef = (TypeRef)ep.getTypes().get(0);
        return new CMElementPropertyInfo<T, C>(this.createPropertyInfoOrigin(ep), classInfo, ep.getName(), ep.isCollection() && !ep.isValueList(), this.getTypeInfo((ElementPropertyInfo<T, C>)ep, (TypeRef<T, C>)typeRef), typeRef.getTagName(), ep.getXmlName());
    }

    protected MPropertyInfo<T, C> createElementsPropertyInfo(MClassInfo<T, C> classInfo, EPI ep) {
        List types = ep.getTypes();
        ArrayList typedElements = new ArrayList(types.size());
        for (TypeRef typeRef : types) {
            typedElements.add(new CMElementTypeInfo<T, C>(typeRef.getTagName(), this.getTypeInfo((ElementPropertyInfo<T, C>)ep, (TypeRef<T, C>)typeRef)));
        }
        return new CMElementsPropertyInfo<T, C>(this.createPropertyInfoOrigin(ep), classInfo, ep.getName(), ep.isCollection() && !ep.isValueList(), typedElements, ep.getXmlName());
    }

    protected MPropertyInfo<T, C> createAnyElementPropertyInfo(MClassInfo<T, C> classInfo, RPI rp) {
        return new CMAnyElementPropertyInfo<T, C>(this.createPropertyInfoOrigin(rp), classInfo, rp.getName(), rp.isCollection(), rp.isMixed(), rp.getWildcard().allowDom, rp.getWildcard().allowTypedObject);
    }

    protected MPropertyInfo<T, C> createElementRefPropertyInfo(MClassInfo<T, C> classInfo, RPI rp) {
        Element element = (Element)rp.getElements().iterator().next();
        return new CMElementRefPropertyInfo<T, C>(this.createPropertyInfoOrigin(rp), classInfo, rp.getName(), rp.isCollection(), this.getTypeInfo((ReferencePropertyInfo<T, C>)rp, (Element<T, C>)element), element.getElementName(), rp.getXmlName(), rp.isMixed(), rp.getWildcard() == null ? false : rp.getWildcard().allowDom, rp.getWildcard() == null ? false : rp.getWildcard().allowTypedObject);
    }

    protected MPropertyInfo<T, C> createElementRefsPropertyInfo(MClassInfo<T, C> classInfo, RPI rp) {
        ArrayList typedElements = new ArrayList();
        for (Element element : rp.getElements()) {
            typedElements.add(new CMElementTypeInfo<T, C>(element.getElementName(), this.getTypeInfo((ReferencePropertyInfo<T, C>)rp, (Element<T, C>)element)));
        }
        return new CMElementRefsPropertyInfo<T, C>(this.createPropertyInfoOrigin(rp), classInfo, rp.getName(), rp.isCollection(), typedElements, rp.getXmlName(), rp.isMixed(), rp.getWildcard() == null ? false : rp.getWildcard().allowDom, rp.getWildcard() == null ? false : rp.getWildcard().allowTypedObject);
    }

    protected CMAnyAttributePropertyInfo<T, C> createAnyAttributePropertyInfo(MClassInfo<T, C> classInfo) {
        return new CMAnyAttributePropertyInfo<T, C>(this.createAnyAttributePropertyInfoOrigin(), classInfo, "otherAttributes");
    }

    protected MTypeInfo<T, C> getTypeInfo(ValuePropertyInfo<T, C> vp) {
        return this.getTypeInfo((PropertyInfo<T, C>)vp, (TI)((TypeInfo)vp.ref().iterator().next()), vp.isCollection(), (Adapter<T, C>)vp.getAdapter(), vp.id(), vp.getExpectedMimeType());
    }

    protected MTypeInfo<T, C> getTypeInfo(AttributePropertyInfo<T, C> ap) {
        return this.getTypeInfo((PropertyInfo<T, C>)ap, (TI)((TypeInfo)ap.ref().iterator().next()), ap.isCollection(), (Adapter<T, C>)ap.getAdapter(), ap.id(), ap.getExpectedMimeType());
    }

    protected MTypeInfo<T, C> getTypeInfo(ElementPropertyInfo<T, C> ep, TypeRef<T, C> typeRef) {
        return this.getTypeInfo((PropertyInfo<T, C>)ep, (TI)typeRef.getTarget(), ep.isValueList(), (Adapter<T, C>)ep.getAdapter(), ep.id(), ep.getExpectedMimeType());
    }

    protected MTypeInfo<T, C> getTypeInfo(ReferencePropertyInfo<T, C> rp, Element<T, C> element) {
        return this.getTypeInfo((PropertyInfo<T, C>)rp, (TI)element, false, (Adapter<T, C>)rp.getAdapter(), rp.id(), rp.getExpectedMimeType());
    }

    protected abstract MPackageInfo getPackage(CI var1);

    protected abstract String getLocalName(CI var1);

    protected abstract MClassInfo<T, C> getScope(CI var1);

    protected abstract MPackageInfo getPackage(ELI var1);

    protected abstract String getLocalName(ELI var1);

    protected abstract String getLocalName(EI var1);

    protected abstract MPackageInfo getPackage(EI var1);

    protected abstract MContainer getContainer(CI var1);

    protected abstract MContainer getContainer(EI var1);

    protected abstract MContainer getContainer(ELI var1);

    protected MBuiltinLeafInfo<T, C> createBuiltinLeafInfo(BLI info) {
        return new CMBuiltinLeafInfo(this.createBuiltinLeafInfoOrigin(info), info.getType(), info.getTypeName());
    }

    protected MEnumLeafInfo<T, C> createEnumLeafInfo(ELI info) {
        NonElement baseType = info.getBaseType();
        return new CMEnumLeafInfo<T, Object>(this.createEnumLeafInfoOrigin(info), info.getClazz(), this.getPackage((EI)info), this.getContainer(info), this.getLocalName((EI)info), this.getTypeInfo((EI)baseType), info.getElementName());
    }

    protected CMEnumConstantInfo<T, C> createEnumContantInfo(MEnumLeafInfo<T, C> enumLeafInfo, EC enumConstant) {
        return new CMEnumConstantInfo<T, C>(this.createEnumConstantInfoOrigin(enumConstant), enumLeafInfo, enumConstant.getLexicalValue());
    }

    protected MElementInfo<T, C> createElementInfo(EI element) {
        ClassInfo scopeCI = element.getScope();
        MClassInfo<T, C> scope = element.getScope() == null ? null : this.getTypeInfo((CI)scopeCI);
        QName substitutionHead = element.getSubstitutionHead() == null ? null : element.getSubstitutionHead().getElementName();
        CMElementInfo<T, C> elementInfo = new CMElementInfo<T, C>(this.createElementInfoOrigin(element), this.getPackage(element), this.getContainer((ELI)element), this.getLocalName(element), element.getElementName(), scope, this.getTypeInfo(element), substitutionHead);
        return elementInfo;
    }

    protected MTypeInfo<T, C> createWildcardTypeInfo(WTI info) {
        return new CMWildcardTypeInfo(this.createWildcardTypeInfoOrigin(info), info.getType());
    }

    protected MModelInfoOrigin createModelInfoOrigin(TIS info) {
        return new CMModelInfoOrigin(info);
    }

    protected MBuiltinLeafInfoOrigin createBuiltinLeafInfoOrigin(BLI info) {
        return new CMBuiltinLeafInfoOrigin(info);
    }

    protected MClassInfoOrigin createClassInfoOrigin(CI info) {
        return new CMClassInfoOrigin(info);
    }

    protected MPropertyInfoOrigin createAnyAttributePropertyInfoOrigin() {
        return new CMAnyAttributePropertyInfoOrigin();
    }

    protected MPropertyInfoOrigin createPropertyInfoOrigin(PI info) {
        return new CMPropertyInfoOrigin(info);
    }

    protected MElementInfoOrigin createElementInfoOrigin(EI info) {
        return new CMElementInfoOrigin(info);
    }

    protected MEnumLeafInfoOrigin createEnumLeafInfoOrigin(ELI info) {
        return new CMEnumLeafInfoOrigin(info);
    }

    protected MEnumConstantInfoOrigin createEnumConstantInfoOrigin(EC info) {
        return new CMEnumConstantInfoOrigin(info);
    }

    protected MWildcardTypeInfoOrigin createWildcardTypeInfoOrigin(WTI info) {
        return new CMWildcardTypeInfoOrigin(info);
    }

    protected abstract T createListType(T var1);
}

