/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.spring;

import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.Outline;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public abstract class AbstractSpringConfigurablePlugin
extends AbstractParameterizablePlugin {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private AbstractXmlApplicationContext applicationContext;
    private String[] configLocations = this.getDefaultConfigLocations();

    public AbstractXmlApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected String[] getDefaultConfigLocations() {
        return null;
    }

    public String[] getConfigLocations() {
        return this.configLocations;
    }

    public void setConfigLocations(String[] configLocations) {
        this.configLocations = configLocations;
    }

    protected int getAutowireMode() {
        return 2;
    }

    protected boolean isDependencyCheck() {
        return false;
    }

    @Override
    public void init(Options options) throws Exception {
    }

    @Override
    protected void beforeRun(Outline outline, Options options) throws Exception {
        super.beforeRun(outline, options);
        Object[] configLocations = this.getConfigLocations();
        if (!ArrayUtils.isEmpty(configLocations)) {
            String configLocationsString = ArrayUtils.toString(configLocations);
            this.logger.debug("Loading application context from [" + configLocationsString + "].");
            try {
                this.applicationContext = new FileSystemXmlApplicationContext((String[])configLocations, false);
                this.applicationContext.setClassLoader(Thread.currentThread().getContextClassLoader());
                this.applicationContext.refresh();
                if (this.getAutowireMode() != 0) {
                    this.applicationContext.getBeanFactory().autowireBeanProperties((Object)this, this.getAutowireMode(), this.isDependencyCheck());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ex.getCause().printStackTrace();
                this.logger.error("Error loading applicaion context from [" + configLocationsString + "].", ex);
                throw new BadCommandLineException("Error loading  applicaion context from [" + configLocationsString + "].", (Throwable)ex);
            }
        }
    }
}

