/*
 * Decompiled with CFR 0.152.
 */
package japa.parser.ast;

import japa.parser.ast.comments.Comment;
import japa.parser.ast.visitor.DumpVisitor;
import japa.parser.ast.visitor.EqualsVisitor;
import japa.parser.ast.visitor.GenericVisitor;
import japa.parser.ast.visitor.VoidVisitor;
import java.util.LinkedList;
import java.util.List;

public abstract class Node {
    private int beginLine;
    private int beginColumn;
    private int endLine;
    private int endColumn;
    private Node parentNode;
    private List<Node> childrenNodes = new LinkedList<Node>();
    private List<Comment> orphanComments = new LinkedList<Comment>();
    private Object data;
    private Comment comment;
    public static final int ABSOLUTE_BEGIN_LINE = -1;
    public static final int ABSOLUTE_END_LINE = -2;

    public Node() {
    }

    public Node(int beginLine, int beginColumn, int endLine, int endColumn) {
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public abstract <R, A> R accept(GenericVisitor<R, A> var1, A var2);

    public abstract <A> void accept(VoidVisitor<A> var1, A var2);

    public final int getBeginColumn() {
        return this.beginColumn;
    }

    public final int getBeginLine() {
        return this.beginLine;
    }

    public final Comment getComment() {
        return this.comment;
    }

    public final Object getData() {
        return this.data;
    }

    public final int getEndColumn() {
        return this.endColumn;
    }

    public final int getEndLine() {
        return this.endLine;
    }

    public final void setBeginColumn(int beginColumn) {
        this.beginColumn = beginColumn;
    }

    public final void setBeginLine(int beginLine) {
        this.beginLine = beginLine;
    }

    public final void setComment(Comment comment) {
        if (comment != null && this instanceof Comment) {
            throw new RuntimeException("A comment can not be commented");
        }
        this.comment = comment;
    }

    public final void setData(Object data) {
        this.data = data;
    }

    public final void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    public final void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public final String toString() {
        DumpVisitor visitor = new DumpVisitor();
        this.accept(visitor, null);
        return visitor.getSource();
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return EqualsVisitor.equals(this, (Node)obj);
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public List<Node> getChildrenNodes() {
        return this.childrenNodes;
    }

    public boolean contains(Node other) {
        if (this.getBeginLine() > other.getBeginLine()) {
            return false;
        }
        if (this.getBeginLine() == other.getBeginLine() && this.getBeginColumn() > other.getBeginColumn()) {
            return false;
        }
        if (this.getEndLine() < other.getEndLine()) {
            return false;
        }
        return this.getEndLine() != other.getEndLine() || this.getEndColumn() >= other.getEndColumn();
    }

    public void addOrphanComment(Comment comment) {
        this.orphanComments.add(comment);
        comment.setParentNode(this);
    }

    public List<Comment> getOrphanComments() {
        return this.orphanComments;
    }

    public List<Comment> getAllContainedComments() {
        LinkedList<Comment> comments = new LinkedList<Comment>();
        comments.addAll(this.getOrphanComments());
        for (Node child : this.getChildrenNodes()) {
            if (child.getComment() != null) {
                comments.add(child.getComment());
            }
            comments.addAll(child.getAllContainedComments());
        }
        return comments;
    }

    public void setParentNode(Node parentNode) {
        if (this.parentNode != null) {
            this.parentNode.childrenNodes.remove(this);
        }
        this.parentNode = parentNode;
        if (this.parentNode != null) {
            this.parentNode.childrenNodes.add(this);
        }
    }

    protected void setAsParentNodeOf(List<? extends Node> childNodes) {
        if (childNodes != null) {
            for (Node node : childNodes) {
                node.setParentNode(this);
            }
        }
    }

    protected void setAsParentNodeOf(Node childNode) {
        if (childNode != null) {
            childNode.setParentNode(this);
        }
    }

    public boolean isPositionedAfter(int line, int column) {
        if (line == -1) {
            return true;
        }
        if (this.getBeginLine() > line) {
            return true;
        }
        if (this.getBeginLine() == line) {
            return this.getBeginColumn() > column;
        }
        return false;
    }

    public boolean isPositionedBefore(int line, int column) {
        if (line == -2) {
            return true;
        }
        if (this.getEndLine() < line) {
            return true;
        }
        if (this.getEndLine() == line) {
            return this.getEndColumn() < column;
        }
        return false;
    }
}

