/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.annotate;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import org.jvnet.annox.model.XAnnotation;
import org.jvnet.annox.model.XAnnotationFieldVisitor;
import org.jvnet.annox.model.annotation.field.XAnnotationField;
import org.jvnet.annox.model.annotation.value.XAnnotationValueVisitor;
import org.jvnet.annox.model.annotation.value.XArrayClassAnnotationValue;
import org.jvnet.annox.model.annotation.value.XBooleanAnnotationValue;
import org.jvnet.annox.model.annotation.value.XByteAnnotationValue;
import org.jvnet.annox.model.annotation.value.XCharAnnotationValue;
import org.jvnet.annox.model.annotation.value.XClassAnnotationValue;
import org.jvnet.annox.model.annotation.value.XClassByNameAnnotationValue;
import org.jvnet.annox.model.annotation.value.XDoubleAnnotationValue;
import org.jvnet.annox.model.annotation.value.XEnumAnnotationValue;
import org.jvnet.annox.model.annotation.value.XEnumByNameAnnotationValue;
import org.jvnet.annox.model.annotation.value.XFloatAnnotationValue;
import org.jvnet.annox.model.annotation.value.XIntAnnotationValue;
import org.jvnet.annox.model.annotation.value.XLongAnnotationValue;
import org.jvnet.annox.model.annotation.value.XShortAnnotationValue;
import org.jvnet.annox.model.annotation.value.XStringAnnotationValue;
import org.jvnet.annox.model.annotation.value.XXAnnotationAnnotationValue;
import org.jvnet.jaxb2_commons.plugin.annotate.AnnotatingVisitor;
import org.jvnet.jaxb2_commons.util.CodeModelUtils;

public class AnnotatingArrayValueVisitor
implements XAnnotationValueVisitor<JAnnotationArrayMember> {
    private final JCodeModel codeModel;
    private final JAnnotationArrayMember annotationArrayMember;

    public AnnotatingArrayValueVisitor(JCodeModel codeModel, JAnnotationArrayMember annotationArrayMember) {
        this.codeModel = codeModel;
        this.annotationArrayMember = annotationArrayMember;
    }

    public JAnnotationArrayMember visit(XXAnnotationAnnotationValue<?> value) {
        XAnnotation xannotation = value.getXAnnotation();
        JAnnotationUse annotationUse = this.annotationArrayMember.annotate(xannotation.getAnnotationClass());
        for (XAnnotationField field : xannotation.getFieldsList()) {
            field.accept((XAnnotationFieldVisitor)new AnnotatingVisitor(this.codeModel, annotationUse));
        }
        return this.annotationArrayMember;
    }

    public JAnnotationArrayMember visit(XBooleanAnnotationValue value) {
        return this.annotationArrayMember.param(((Boolean)value.getValue()).booleanValue());
    }

    public JAnnotationArrayMember visit(XByteAnnotationValue value) {
        return this.annotationArrayMember.param(((Byte)value.getValue()).byteValue());
    }

    public JAnnotationArrayMember visit(XCharAnnotationValue value) {
        return this.annotationArrayMember.param(((Character)value.getValue()).charValue());
    }

    public JAnnotationArrayMember visit(XDoubleAnnotationValue value) {
        return this.annotationArrayMember.param(((Double)value.getValue()).doubleValue());
    }

    public JAnnotationArrayMember visit(XFloatAnnotationValue value) {
        return this.annotationArrayMember.param(((Float)value.getValue()).floatValue());
    }

    public JAnnotationArrayMember visit(XIntAnnotationValue value) {
        return this.annotationArrayMember.param(((Integer)value.getValue()).intValue());
    }

    public JAnnotationArrayMember visit(XLongAnnotationValue value) {
        return this.annotationArrayMember.param(((Long)value.getValue()).longValue());
    }

    public JAnnotationArrayMember visit(XShortAnnotationValue value) {
        return this.annotationArrayMember.param(((Short)value.getValue()).shortValue());
    }

    public JAnnotationArrayMember visit(XStringAnnotationValue value) {
        return this.annotationArrayMember.param((String)value.getValue());
    }

    public JAnnotationArrayMember visit(XEnumAnnotationValue<?> value) {
        Enum e = (Enum)value.getValue();
        return this.annotationArrayMember.param(e);
    }

    public JAnnotationArrayMember visit(XEnumByNameAnnotationValue<?> value) {
        JClass type = (JClass)CodeModelUtils.ref((JCodeModel)this.codeModel, (String)value.getEnumClassName());
        return this.annotationArrayMember.param((JExpression)type.staticRef(value.getName()));
    }

    public JAnnotationArrayMember visit(XClassAnnotationValue<?> value) {
        Class _class = (Class)value.getValue();
        return this.annotationArrayMember.param(_class);
    }

    public JAnnotationArrayMember visit(XClassByNameAnnotationValue<?> value) {
        JType ref = CodeModelUtils.ref((JCodeModel)this.codeModel, (String)value.getClassName());
        return this.annotationArrayMember.param(ref);
    }

    public JAnnotationArrayMember visit(XArrayClassAnnotationValue<?, ?> value) {
        JType type = CodeModelUtils.ref((JCodeModel)this.codeModel, (String)value.getItemClassName());
        for (int index = 0; index < value.getDimension(); ++index) {
            type = type.array();
        }
        return this.annotationArrayMember.param(type);
    }
}

