/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.annotate;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.jvnet.annox.model.XAnnotation;
import org.jvnet.annox.parser.XAnnotationParser;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.plugin.annotate.Annotator;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;
import org.jvnet.jaxb2_commons.util.FieldAccessorUtils;
import org.jvnet.jaxb2_commons.util.OutlineUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AnnotatePlugin
extends AbstractParameterizablePlugin {
    private static final QName ANNOTATE_PROPERTY_QNAME = new QName("http://annox.dev.java.net", "annotateProperty");
    private static final QName ANNOTATE_PACKAGE_QNAME = new QName("http://annox.dev.java.net", "annotatePackage");
    private static final QName ANNOTATE_CLASS_QNAME = new QName("http://annox.dev.java.net", "annotateClass");
    private static final QName ANNOTATE_ELEMENT_QNAME = new QName("http://annox.dev.java.net", "annotateElement");
    private static final QName ANNOTATE_ENUM_QNAME = new QName("http://annox.dev.java.net", "annotateEnum");
    private static final QName ANNOTATE_ENUM_CONSTANT_QNAME = new QName("http://annox.dev.java.net", "annotateEnumConstant");
    private static final QName ANNOTATE_QNAME = new QName("http://annox.dev.java.net", "annotate");
    private String defaultFieldTarget = "getter";
    private XAnnotationParser annotationParser = XAnnotationParser.INSTANCE;
    private Annotator annotator = new Annotator();

    public String getOptionName() {
        return "Xannotate";
    }

    public String getUsage() {
        return "TBD";
    }

    public String getDefaultFieldTarget() {
        return this.defaultFieldTarget;
    }

    public void setDefaultFieldTarget(String defaultFieldTarget) {
        if (!("getter".equals(defaultFieldTarget) || "setter".equals(defaultFieldTarget) || "setter-parameter".equals(defaultFieldTarget) || "field".equals(defaultFieldTarget))) {
            throw new IllegalArgumentException("Invalid default field target.");
        }
        this.defaultFieldTarget = defaultFieldTarget;
    }

    public XAnnotationParser getAnnotationParser() {
        return this.annotationParser;
    }

    public void setAnnotationParser(XAnnotationParser annotationParser) {
        this.annotationParser = annotationParser;
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    public void setAnnotator(Annotator annotator) {
        this.annotator = annotator;
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        for (CElementInfo elementInfo : outline.getModel().getAllElements()) {
            ElementOutline elementOutline = outline.getElement(elementInfo);
            if (elementOutline == null) continue;
            this.processElementOutline(elementOutline, options, errorHandler);
        }
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClassOutline(classOutline, options, errorHandler);
        }
        for (EnumOutline enumOutline : outline.getEnums()) {
            this.processEnumOutline(enumOutline, options, errorHandler);
        }
        return true;
    }

    protected void processElementOutline(ElementOutline elementOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((ElementOutline)elementOutline);
        this.annotateElementOutline(elementOutline.implClass.owner(), elementOutline, customizations, errorHandler);
    }

    protected void processEnumOutline(EnumOutline enumOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((EnumOutline)enumOutline);
        this.annotateEnumOutline(enumOutline.clazz.owner(), enumOutline, customizations, errorHandler);
        for (EnumConstantOutline enumConstantOutline : enumOutline.constants) {
            this.processEnumConstantOutline(enumOutline, enumConstantOutline, options, errorHandler);
        }
    }

    protected void processClassOutline(ClassOutline classOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((ClassOutline)classOutline);
        this.annotateClassOutline(classOutline.ref.owner(), classOutline, customizations, errorHandler);
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            this.processFieldOutline(classOutline, fieldOutline, options, errorHandler);
        }
    }

    private void processFieldOutline(ClassOutline classOutline, FieldOutline fieldOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((FieldOutline)fieldOutline);
        this.annotate(fieldOutline.parent().ref.owner(), fieldOutline, customizations, errorHandler);
    }

    private void processEnumConstantOutline(EnumOutline enumOutline, EnumConstantOutline enumConstantOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((EnumConstantOutline)enumConstantOutline);
        this.annotateEnumConstantOutline(enumOutline.parent().getCodeModel(), enumConstantOutline, customizations, errorHandler);
    }

    protected void annotateElementOutline(JCodeModel codeModel, ElementOutline elementOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!"http://annox.dev.java.net".equals(name.getNamespaceURI())) continue;
            customization.markAsAcknowledged();
            if (!ANNOTATE_QNAME.equals(name) && !ANNOTATE_ELEMENT_QNAME.equals(name)) continue;
            JDefinedClass annotatable = elementOutline.implClass;
            this.annotate(codeModel, errorHandler, customization, element, (JAnnotatable)annotatable);
        }
    }

    protected void annotateEnumOutline(JCodeModel codeModel, EnumOutline enumOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!"http://annox.dev.java.net".equals(name.getNamespaceURI())) continue;
            customization.markAsAcknowledged();
            if (!ANNOTATE_QNAME.equals(name) && !ANNOTATE_ENUM_QNAME.equals(name)) continue;
            JDefinedClass annotatable = enumOutline.clazz;
            this.annotate(codeModel, errorHandler, customization, element, (JAnnotatable)annotatable);
        }
    }

    protected void annotateEnumConstantOutline(JCodeModel codeModel, EnumConstantOutline enumConstantOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!"http://annox.dev.java.net".equals(name.getNamespaceURI())) continue;
            customization.markAsAcknowledged();
            customization.markAsAcknowledged();
            if (!ANNOTATE_QNAME.equals(name) && !ANNOTATE_ENUM_CONSTANT_QNAME.equals(name)) continue;
            JEnumConstant annotatable = enumConstantOutline.constRef;
            this.annotate(codeModel, errorHandler, customization, element, (JAnnotatable)annotatable);
        }
    }

    protected void annotateClassOutline(JCodeModel codeModel, ClassOutline classOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!"http://annox.dev.java.net".equals(name.getNamespaceURI())) continue;
            customization.markAsAcknowledged();
            customization.markAsAcknowledged();
            if (!ANNOTATE_CLASS_QNAME.equals(name) && !ANNOTATE_QNAME.equals(name)) continue;
            String draftTarget = element.getAttribute("target");
            String target = draftTarget == null || "".equals(draftTarget) ? null : draftTarget;
            Object annotatable = "package".equals(target) ? classOutline.ref._package() : classOutline.ref;
            this.annotate(codeModel, errorHandler, customization, element, (JAnnotatable)annotatable);
        }
    }

    protected void annotate(JCodeModel codeModel, FieldOutline fieldOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            JMethod _setter;
            JPackage annotatable;
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!"http://annox.dev.java.net".equals(name.getNamespaceURI())) continue;
            customization.markAsAcknowledged();
            customization.markAsAcknowledged();
            if (!ANNOTATE_QNAME.equals(name) && !ANNOTATE_PROPERTY_QNAME.equals(name)) continue;
            String draftTarget = element.getAttribute("target");
            String target = draftTarget == null || "".equals(draftTarget) ? this.getDefaultFieldTarget() : draftTarget;
            if ("package".equals(target)) {
                annotatable = fieldOutline.parent().ref._package();
            } else if ("class".equals(target)) {
                annotatable = fieldOutline.parent().ref;
            } else if ("getter".equals(target)) {
                JMethod _getter = FieldAccessorUtils.getter((FieldOutline)fieldOutline);
                if (_getter == null) {
                    this.logger.error((Object)MessageFormat.format("Could not annotate the getter of the field outline [{0}], getter method could not be found.", OutlineUtils.getFieldName((FieldOutline)fieldOutline)));
                }
                annotatable = _getter;
            } else if ("setter".equals(target)) {
                _setter = FieldAccessorUtils.setter((FieldOutline)fieldOutline);
                if (_setter == null) {
                    this.logger.error((Object)MessageFormat.format("Could not annotate the setter of the field outline [{0}], setter method could not be found.", OutlineUtils.getFieldName((FieldOutline)fieldOutline)));
                }
                annotatable = _setter;
            } else if ("setter-parameter".equals(target)) {
                _setter = FieldAccessorUtils.setter((FieldOutline)fieldOutline);
                if (_setter == null) {
                    this.logger.error((Object)MessageFormat.format("Could not annotate the setter parameter of the field outline [{0}], setter method could not be found.", OutlineUtils.getFieldName((FieldOutline)fieldOutline)));
                    annotatable = null;
                } else {
                    JVar[] params = _setter.listParams();
                    if (params.length != 1) {
                        this.logger.error((Object)MessageFormat.format("Could not annotate the setter parameter of the field outline [{0}], setter method must have a single parameter(this setter has {1}).", OutlineUtils.getFieldName((FieldOutline)fieldOutline), params.length));
                        annotatable = null;
                    } else {
                        annotatable = FieldAccessorUtils.setter((FieldOutline)fieldOutline).listParams()[0];
                    }
                }
            } else if ("field".equals(target)) {
                JFieldVar _field = FieldAccessorUtils.field((FieldOutline)fieldOutline);
                if (_field == null) {
                    this.logger.error((Object)MessageFormat.format("Could not annotate the field of the field outline [{0}] since it could not be found.", OutlineUtils.getFieldName((FieldOutline)fieldOutline)));
                }
                annotatable = _field;
            } else {
                this.logger.error((Object)("Invalid annotation target [" + target + "]."));
                annotatable = null;
            }
            if (annotatable == null) continue;
            this.annotate(codeModel, errorHandler, customization, element, (JAnnotatable)annotatable);
        }
    }

    private void annotate(JCodeModel codeModel, ErrorHandler errorHandler, CPluginCustomization customization, Element element, JAnnotatable annotatable) {
        NodeList elements = element.getChildNodes();
        for (int index = 0; index < elements.getLength(); ++index) {
            String nodeValue;
            XAnnotation annotation;
            Node node = elements.item(index);
            if (node.getNodeType() == 1) {
                Element child = (Element)node;
                try {
                    annotation = this.getAnnotationParser().parse(child);
                    this.getAnnotator().annotate(codeModel, annotatable, annotation);
                }
                catch (Exception ex) {
                    try {
                        errorHandler.error(new SAXParseException("Error parsing annotation.", customization.locator, ex));
                    }
                    catch (SAXException ignored) {}
                }
                continue;
            }
            if (node.getNodeType() != 3 || (nodeValue = node.getNodeValue()) == null || !StringUtils.isNotBlank((CharSequence)nodeValue)) continue;
            try {
                annotation = this.getAnnotationParser().parse(nodeValue);
                this.getAnnotator().annotate(codeModel, annotatable, annotation);
                continue;
            }
            catch (Exception ex) {
                try {
                    errorHandler.error(new SAXParseException("Error parsing annotation.", customization.locator, ex));
                    continue;
                }
                catch (SAXException ignored) {
                    // empty catch block
                }
            }
        }
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(ANNOTATE_QNAME, ANNOTATE_PACKAGE_QNAME, ANNOTATE_CLASS_QNAME, ANNOTATE_ELEMENT_QNAME, ANNOTATE_PROPERTY_QNAME);
    }
}

