/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.annotate;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JType;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.jvnet.annox.model.XAnnotation;
import org.jvnet.annox.model.XAnnotationField;
import org.jvnet.annox.model.XAnnotationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotator {
    public static final Annotator INSTANCE = new Annotator();

    public void annotate(JCodeModel codeModel, JAnnotatable annotatable, Collection<XAnnotation> xannotations) {
        for (XAnnotation xannotation : xannotations) {
            if (xannotation == null) continue;
            this.annotate(codeModel, annotatable, xannotation);
        }
    }

    public void annotate(JCodeModel codeModel, JAnnotatable annotatable, XAnnotation xannotation) {
        JAnnotationUse annotationUse = annotatable.annotate(xannotation.getAnnotationClass());
        AnnotatingFieldVisitor visitor = new AnnotatingFieldVisitor(codeModel, annotationUse);
        xannotation.accept((XAnnotationVisitor)visitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatingFieldVisitor
    implements XAnnotationVisitor<JAnnotationUse> {
        private final JCodeModel codeModel;
        private final JAnnotationUse use;

        public AnnotatingFieldVisitor(JCodeModel codeModel, JAnnotationUse use) {
            this.codeModel = codeModel;
            this.use = use;
        }

        public JAnnotationUse visitAnnotation(XAnnotation annotation) {
            for (XAnnotationField field : annotation.getFieldsList()) {
                field.accept((XAnnotationVisitor)this);
            }
            return this.use;
        }

        public JAnnotationUse visitBooleanField(XAnnotationField.XBoolean field) {
            return this.use.param(field.getName(), ((Boolean)field.getValue()).booleanValue());
        }

        public JAnnotationUse visitByteField(XAnnotationField.XByte field) {
            return this.use.param(field.getName(), (int)((Byte)field.getValue()).byteValue());
        }

        public JAnnotationUse visitCharField(XAnnotationField.XChar field) {
            return this.use.param(field.getName(), (int)((Character)field.getValue()).charValue());
        }

        public JAnnotationUse visitClassField(XAnnotationField.XClass field) {
            JClass type = this.codeModel.ref(field.getClassName());
            return this.use.param(field.getName(), (JType)type);
        }

        public JAnnotationUse visitDoubleField(XAnnotationField.XDouble field) {
            return this.use.param(field.getName(), ((Double)field.getValue()).intValue());
        }

        public JAnnotationUse visitEnumField(XAnnotationField.XEnum field) {
            return this.use.param(field.getName(), (Enum)field.getValue());
        }

        public JAnnotationUse visitFloatField(XAnnotationField.XFloat field) {
            return this.use.param(field.getName(), ((Float)field.getValue()).intValue());
        }

        public JAnnotationUse visitIntField(XAnnotationField.XInt field) {
            return this.use.param(field.getName(), ((Integer)field.getValue()).intValue());
        }

        public JAnnotationUse visitLongField(XAnnotationField.XLong field) {
            return this.use.param(field.getName(), ((Long)field.getValue()).intValue());
        }

        public JAnnotationUse visitShortField(XAnnotationField.XShort field) {
            return this.use.param(field.getName(), (int)((Short)field.getValue()).shortValue());
        }

        public JAnnotationUse visitStringField(XAnnotationField.XString field) {
            return this.use.param(field.getName(), (String)field.getValue());
        }

        public JAnnotationUse visitBooleanArrayField(XAnnotationField.XBooleanArray field) {
            JAnnotationArrayMember array = this.use.paramArray(field.getName());
            for (Boolean value : (Boolean[])field.getValue()) {
                array.param(value.booleanValue());
            }
            return this.use;
        }

        public JAnnotationUse visitByteArrayField(XAnnotationField.XByteArray field) {
            JAnnotationArrayMember array = this.use.paramArray(field.getName());
            for (Byte value : (Byte[])field.getValue()) {
                array.param((int)value.byteValue());
            }
            return this.use;
        }

        public JAnnotationUse visitCharArrayField(XAnnotationField.XCharArray field) {
            JAnnotationArrayMember array = this.use.paramArray(field.getName());
            for (Character value : (Character[])field.getValue()) {
                array.param((int)value.charValue());
            }
            return this.use;
        }

        public JAnnotationUse visitClassArrayField(XAnnotationField.XClassArray field) {
            JAnnotationArrayMember array = this.use.paramArray(field.getName());
            for (String className : field.getClassNames()) {
                JClass type = this.codeModel.ref(className);
                array.param((JType)type);
            }
            return this.use;
        }

        public JAnnotationUse visitDoubleArrayField(XAnnotationField.XDoubleArray field) {
            JAnnotationArrayMember array = this.use.paramArray(field.getName());
            for (Double value : (Double[])field.getValue()) {
                array.param(value.intValue());
            }
            return this.use;
        }

        public JAnnotationUse visitEnumArrayField(XAnnotationField.XEnumArray field) {
            JAnnotationArrayMember array = this.use.paramArray(field.getName());
            for (final Enum value : (Enum[])field.getValue()) {
                JAnnotationValue annotationValue = new JAnnotationValue(){

                    public void generate(JFormatter f) {
                        f.t(AnnotatingFieldVisitor.this.codeModel.ref(value.getDeclaringClass())).p('.').p(value.name());
                    }
                };
                this.addParam(array, annotationValue);
            }
            return this.use;
        }

        public void addParam(JAnnotationArrayMember array, JAnnotationValue annotationValue) {
            try {
                Field values = JAnnotationArrayMember.class.getDeclaredField("values");
                values.setAccessible(true);
                ((List)values.get(array)).add(annotationValue);
            }
            catch (Exception ex) {
                throw new AssertionError((Object)ex);
            }
        }

        public JAnnotationUse visitFloatArrayField(XAnnotationField.XFloatArray field) {
            JAnnotationArrayMember array = this.use.paramArray(field.getName());
            for (Float value : (Float[])field.getValue()) {
                array.param(value.intValue());
            }
            return this.use;
        }

        public JAnnotationUse visitIntArrayField(XAnnotationField.XIntArray field) {
            JAnnotationArrayMember array = this.use.paramArray(field.getName());
            for (Integer value : (Integer[])field.getValue()) {
                array.param(value.intValue());
            }
            return this.use;
        }

        public JAnnotationUse visitShortArrayField(XAnnotationField.XShortArray field) {
            JAnnotationArrayMember array = this.use.paramArray(field.getName());
            for (Short value : (Short[])field.getValue()) {
                array.param((int)value.shortValue());
            }
            return this.use;
        }

        public JAnnotationUse visitStringArrayField(XAnnotationField.XStringArray field) {
            JAnnotationArrayMember array = this.use.paramArray(field.getName());
            for (String value : (String[])field.getValue()) {
                array.param(value);
            }
            return this.use;
        }

        public JAnnotationUse visitAnnotationArrayField(XAnnotationField.XAnnotationArray field) {
            XAnnotation[] annotations;
            JAnnotationArrayMember array = this.use.paramArray(field.getName());
            for (XAnnotation annotation : annotations = (XAnnotation[])field.getValue()) {
                JAnnotationUse annotationUse = array.annotate(annotation.getAnnotationClass());
                AnnotatingFieldVisitor visitor = new AnnotatingFieldVisitor(this.codeModel, annotationUse);
                annotation.accept((XAnnotationVisitor)visitor);
            }
            return this.use;
        }

        public JAnnotationUse visitLongArrayField(XAnnotationField.XLongArray field) {
            JAnnotationArrayMember array = this.use.paramArray(field.getName());
            for (Long value : (Long[])field.getValue()) {
                array.param((float)value.longValue());
            }
            return this.use;
        }

        public JAnnotationUse visitAnnotationField(XAnnotationField.XAnnotation field) {
            JAnnotationUse annotationUse = this.use.annotationParam(field.getName(), field.getAnnotationClass());
            AnnotatingFieldVisitor visitor = new AnnotatingFieldVisitor(this.codeModel, annotationUse);
            return (JAnnotationUse)((XAnnotation)field.getValue()).accept((XAnnotationVisitor)visitor);
        }
    }
}

