/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.annotate;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Collections;
import java.util.List;
import org.jvnet.annox.model.XAnnotation;
import org.jvnet.annox.parser.XAnnotationParser;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.plugin.annotate.Annotator;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;
import org.jvnet.jaxb2_commons.util.FieldAccessorUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatePlugin
extends AbstractParameterizablePlugin {
    private String defaultFieldTarget = "getter";
    private XAnnotationParser annotationParser = XAnnotationParser.GENERIC;
    private Annotator annotator = new Annotator();

    public String getOptionName() {
        return "Xannotate";
    }

    public String getUsage() {
        return "TBD";
    }

    public String getDefaultFieldTarget() {
        return this.defaultFieldTarget;
    }

    public void setDefaultFieldTarget(String defaultFieldTarget) {
        if (!("getter".equals(defaultFieldTarget) || "setter".equals(defaultFieldTarget) || "field".equals(defaultFieldTarget))) {
            throw new IllegalArgumentException("Invalid default field target.");
        }
        this.defaultFieldTarget = defaultFieldTarget;
    }

    public XAnnotationParser getAnnotationParser() {
        return this.annotationParser;
    }

    public void setAnnotationParser(XAnnotationParser annotationParser) {
        this.annotationParser = annotationParser;
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    public void setAnnotator(Annotator annotator) {
        this.annotator = annotator;
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClassOutline(classOutline, options, errorHandler);
        }
        return true;
    }

    protected void processClassOutline(ClassOutline classOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((ClassOutline)classOutline);
        this.annotateClassOutline(classOutline.ref.owner(), classOutline, customizations, errorHandler);
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            this.processFieldOutline(classOutline, fieldOutline, options, errorHandler);
        }
    }

    private void processFieldOutline(ClassOutline classOutline, FieldOutline fieldOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((FieldOutline)fieldOutline);
        this.annotate(fieldOutline.parent().ref.owner(), fieldOutline, customizations, errorHandler);
    }

    protected void annotateClassOutline(JCodeModel codeModel, ClassOutline classOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            String namespaceURI = element.getNamespaceURI();
            if (!"http://annox.dev.java.net".equals(namespaceURI)) continue;
            customization.markAsAcknowledged();
            JDefinedClass annotatable = classOutline.ref;
            this.annotate(codeModel, errorHandler, customization, element, (JAnnotatable)annotatable);
        }
    }

    protected void annotate(JCodeModel codeModel, FieldOutline fieldOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            JDefinedClass annotatable;
            Element element = customization.element;
            String namespaceURI = element.getNamespaceURI();
            if (!"http://annox.dev.java.net".equals(namespaceURI)) continue;
            customization.markAsAcknowledged();
            String draftTarget = element.getAttribute("target");
            String target = draftTarget == null || "".equals(draftTarget) ? this.getDefaultFieldTarget() : draftTarget;
            if ("class".equals(target)) {
                annotatable = fieldOutline.parent().ref;
            } else if ("getter".equals(target)) {
                annotatable = FieldAccessorUtils.getter((FieldOutline)fieldOutline);
            } else if ("setter".equals(target)) {
                annotatable = FieldAccessorUtils.setter((FieldOutline)fieldOutline);
            } else if ("field".equals(target)) {
                annotatable = FieldAccessorUtils.field((FieldOutline)fieldOutline);
            } else {
                this.logger.error((Object)("Invalid annotation target [" + target + "]."));
                annotatable = null;
            }
            if (annotatable == null) continue;
            this.annotate(codeModel, errorHandler, customization, element, (JAnnotatable)annotatable);
        }
    }

    private void annotate(JCodeModel codeModel, ErrorHandler errorHandler, CPluginCustomization customization, Element element, JAnnotatable annotatable) {
        NodeList elements = element.getChildNodes();
        for (int index = 0; index < elements.getLength(); ++index) {
            Node node = elements.item(index);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            try {
                XAnnotation annotation = this.getAnnotationParser().parse(child);
                this.getAnnotator().annotate(codeModel, annotatable, annotation);
                continue;
            }
            catch (Exception ex) {
                try {
                    errorHandler.error(new SAXParseException("Error parsing annotation.", customization.locator, ex));
                    continue;
                }
                catch (SAXException ignored) {
                    // empty catch block
                }
            }
        }
    }

    public List<String> getCustomizationURIs() {
        return Collections.singletonList("http://annox.dev.java.net");
    }

    public boolean isCustomizationTagName(String namespaceURI, String localName) {
        return "http://annox.dev.java.net".equals(namespaceURI) && "annotate".equals(localName);
    }
}

