/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.inheritance;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CClass;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassRef;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.outline.PackageOutline;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.plugin.inheritance.Customizations;
import org.jvnet.jaxb2_commons.plugin.inheritance.ExtendsClass;
import org.jvnet.jaxb2_commons.plugin.inheritance.ImplementsInterface;
import org.jvnet.jaxb2_commons.plugin.inheritance.ObjectFactoryCustomization;
import org.jvnet.jaxb2_commons.plugin.inheritance.util.JavaTypeParser;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;
import org.xml.sax.ErrorHandler;

public class InheritancePlugin
extends AbstractParameterizablePlugin {
    public String getOptionName() {
        return "Xinheritance";
    }

    public String getUsage() {
        return "TBD";
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.EXTENDS_ELEMENT_NAME, Customizations.IMPLEMENTS_ELEMENT_NAME, Customizations.OBJECT_FACTORY_ELEMENT_NAME);
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        HashMap<String, JClass> knownClasses = new HashMap<String, JClass>();
        IdentityHashMap<JClass, CClassInfo> knownClassInfos = new IdentityHashMap<JClass, CClassInfo>();
        for (ClassOutline classOutline : outline.getClasses()) {
            knownClasses.put(classOutline.implClass.fullName(), (JClass)classOutline.implClass);
            knownClassInfos.put((JClass)classOutline.implClass, classOutline.target);
        }
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClassOutline(classOutline, knownClasses, knownClassInfos);
        }
        for (EnumOutline enumOutline : outline.getEnums()) {
            this.processEnumOutline(enumOutline, knownClasses);
        }
        for (CElementInfo elementInfo : outline.getModel().getAllElements()) {
            ElementOutline elementOutline = outline.getElement(elementInfo);
            if (elementOutline == null) continue;
            this.processElementOutline(elementOutline, knownClasses);
        }
        this.processPackageOutlines(outline, knownClasses);
        return true;
    }

    private void processClassOutline(ClassOutline classOutline, Map<String, JClass> knownClasses, Map<JClass, CClassInfo> knownClassInfos) {
        this.generateExtends(classOutline, knownClasses, knownClassInfos);
        this.generateImplements(classOutline, knownClasses);
        this.ignoreCustomzationsOnProperties(classOutline);
    }

    private void ignoreCustomzationsOnProperties(ClassOutline classOutline) {
        for (CPropertyInfo propertyInfo : classOutline.target.getProperties()) {
            CustomizationUtils.findCustomization((CPropertyInfo)propertyInfo, (QName)Customizations.EXTENDS_ELEMENT_NAME);
            CustomizationUtils.findCustomization((CPropertyInfo)propertyInfo, (QName)Customizations.IMPLEMENTS_ELEMENT_NAME);
        }
    }

    private void processEnumOutline(EnumOutline enumOutline, Map<String, JClass> knownClasses) {
        this.generateExtends(enumOutline, knownClasses);
        this.generateImplements(enumOutline, knownClasses);
    }

    private void processElementOutline(ElementOutline elementOutline, Map<String, JClass> knownClasses) {
        this.generateExtends(elementOutline, knownClasses);
        this.generateImplements(elementOutline, knownClasses);
    }

    private void processPackageOutlines(Outline outline, Map<String, JClass> knownClasses) {
        List customizations = CustomizationUtils.findCustomizations((Outline)outline, (QName)Customizations.OBJECT_FACTORY_ELEMENT_NAME);
        for (CPluginCustomization customization : customizations) {
            ObjectFactoryCustomization objectFactoryCustomization = (ObjectFactoryCustomization)CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)customization);
            String packageName = objectFactoryCustomization.getPackageName();
            if (packageName == null) continue;
            for (PackageOutline packageOutline : outline.getAllPackageContexts()) {
                List<ImplementsInterface> implementsInterfaces;
                JDefinedClass theClass = packageOutline.objectFactory();
                if (!packageName.equals(packageOutline._package().name())) continue;
                ExtendsClass extendsClass = objectFactoryCustomization.getExtendsClass();
                if (extendsClass != null) {
                    this.generateExtends(theClass, extendsClass, knownClasses);
                }
                if ((implementsInterfaces = objectFactoryCustomization.getImplementsInterface()) == null) continue;
                for (ImplementsInterface implementsInterface : implementsInterfaces) {
                    if (implementsInterface == null) continue;
                    this.generateImplements(theClass, implementsInterface, knownClasses);
                }
            }
        }
    }

    private JClass generateExtends(ClassOutline classOutline, Map<String, JClass> knownClasses, Map<JClass, CClassInfo> knownClassInfos) {
        JDefinedClass theClass = classOutline.implClass;
        CPluginCustomization extendsClassCustomization = CustomizationUtils.findCustomization((ClassOutline)classOutline, (QName)Customizations.EXTENDS_ELEMENT_NAME);
        JClass targetClass = this.generateExtends(theClass, extendsClassCustomization, knownClasses);
        CClassInfo classInfo = classOutline.target;
        if (targetClass != null && classInfo.getBaseClass() == null && classInfo.getRefBaseClass() == null) {
            CClassInfo targetClassInfo = knownClassInfos.get(targetClass);
            if (targetClassInfo == null && classInfo.getRefBaseClass() == null) {
                Model model = classInfo.model;
                BIEnum decl = new BIEnum();
                decl.ref = targetClass.fullName();
                CClassRef baseClass = new CClassRef(model, classInfo.getSchemaComponent(), decl, new CCustomizations());
                classInfo.setBaseClass((CClass)baseClass);
            } else if (targetClassInfo != null && classInfo.getBaseClass() == null) {
                classInfo.setBaseClass((CClass)targetClassInfo);
            }
        }
        return targetClass;
    }

    private JClass generateExtends(EnumOutline enumOutline, Map<String, JClass> knownClasses) {
        JDefinedClass theClass = enumOutline.clazz;
        CPluginCustomization extendsClassCustomization = CustomizationUtils.findCustomization((EnumOutline)enumOutline, (QName)Customizations.EXTENDS_ELEMENT_NAME);
        return this.generateExtends(theClass, extendsClassCustomization, knownClasses);
    }

    private JClass generateExtends(ElementOutline elementOutline, Map<String, JClass> knownClasses) {
        JDefinedClass theClass = elementOutline.implClass;
        CPluginCustomization extendsClassCustomization = CustomizationUtils.findCustomization((ElementOutline)elementOutline, (QName)Customizations.EXTENDS_ELEMENT_NAME);
        return this.generateExtends(theClass, extendsClassCustomization, knownClasses);
    }

    private JClass generateExtends(JDefinedClass theClass, CPluginCustomization extendsClassCustomization, Map<String, JClass> knownClasses) throws AssertionError {
        if (extendsClassCustomization != null) {
            ExtendsClass extendsClass = (ExtendsClass)CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)extendsClassCustomization);
            return this.generateExtends(theClass, extendsClass, knownClasses);
        }
        return null;
    }

    private JClass generateExtends(JDefinedClass theClass, ExtendsClass extendsClass, Map<String, JClass> knownClasses) {
        if (extendsClass.getClassName() != null) {
            String _class = extendsClass.getClassName();
            JClass targetClass = this.parseClass(_class, theClass.owner(), knownClasses);
            theClass._extends(targetClass);
            return targetClass;
        }
        return null;
    }

    private List<JClass> generateImplements(ClassOutline classOutline, Map<String, JClass> knownClasses) {
        JDefinedClass theClass = classOutline.implClass;
        List implementsInterfaceCustomizations = CustomizationUtils.findCustomizations((ClassOutline)classOutline, (QName)Customizations.IMPLEMENTS_ELEMENT_NAME);
        return this.generateImplements(theClass, implementsInterfaceCustomizations, knownClasses);
    }

    private List<JClass> generateImplements(EnumOutline enumOutline, Map<String, JClass> knownClasses) {
        JDefinedClass theClass = enumOutline.clazz;
        List implementsInterfaceCustomizations = CustomizationUtils.findCustomizations((EnumOutline)enumOutline, (QName)Customizations.IMPLEMENTS_ELEMENT_NAME);
        return this.generateImplements(theClass, implementsInterfaceCustomizations, knownClasses);
    }

    private List<JClass> generateImplements(ElementOutline elementOutline, Map<String, JClass> knownClasses) {
        JDefinedClass theClass = elementOutline.implClass;
        List implementsInterfaceCustomizations = CustomizationUtils.findCustomizations((ElementOutline)elementOutline, (QName)Customizations.IMPLEMENTS_ELEMENT_NAME);
        return this.generateImplements(theClass, implementsInterfaceCustomizations, knownClasses);
    }

    private List<JClass> generateImplements(JDefinedClass theClass, List<CPluginCustomization> implementsInterfaceCustomizations, Map<String, JClass> knownClasses) throws AssertionError {
        ArrayList<JClass> implementedInterfaces = new ArrayList<JClass>(implementsInterfaceCustomizations.size());
        for (CPluginCustomization implementsInterfaceCustomization : implementsInterfaceCustomizations) {
            ImplementsInterface implementsInterface;
            JClass implementedInterface;
            if (implementsInterfaceCustomization == null || (implementedInterface = this.generateImplements(theClass, implementsInterface = (ImplementsInterface)CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)implementsInterfaceCustomization), knownClasses)) == null) continue;
            implementedInterfaces.add(implementedInterface);
        }
        return implementedInterfaces;
    }

    private JClass generateImplements(JDefinedClass theClass, ImplementsInterface implementsInterface, Map<String, JClass> knownClasses) {
        String _interface = implementsInterface.getInterfaceName();
        if (_interface != null) {
            JClass targetClass = this.parseClass(_interface, theClass.owner(), knownClasses);
            theClass._implements(targetClass);
            return targetClass;
        }
        return null;
    }

    private JClass parseClass(String _class, JCodeModel codeModel, Map<String, JClass> knownClasses) {
        return new JavaTypeParser(knownClasses).parseClass(_class, codeModel);
    }
}

