/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.plugin.inheritance.util;

import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.type.WildcardType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.GenericVisitorAdapter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TypeToJTypeConvertingVisitor
extends GenericVisitorAdapter<JType, JCodeModel> {
    private final Map<String, JClass> knownClasses;

    public TypeToJTypeConvertingVisitor(Map<String, JClass> knownClasses) {
        Objects.requireNonNull(knownClasses, "Known classes must not be null. Use empty map instead of null to indicate no known classes.");
        this.knownClasses = knownClasses;
    }

    public JType visit(VoidType type, JCodeModel codeModel) {
        return codeModel.VOID;
    }

    public JType visit(PrimitiveType type, JCodeModel codeModel) {
        switch (type.getType()) {
            case BOOLEAN: {
                return codeModel.BOOLEAN;
            }
            case CHAR: {
                return codeModel.CHAR;
            }
            case BYTE: {
                return codeModel.BYTE;
            }
            case SHORT: {
                return codeModel.SHORT;
            }
            case INT: {
                return codeModel.INT;
            }
            case LONG: {
                return codeModel.LONG;
            }
            case FLOAT: {
                return codeModel.FLOAT;
            }
            case DOUBLE: {
                return codeModel.DOUBLE;
            }
        }
        throw new AssertionError((Object)("Unknown primitive type [" + String.valueOf(type.getType()) + "]"));
    }

    public JType visit(ArrayType type, JCodeModel codeModel) {
        JType referencedType;
        JType referencedTypeArray = referencedType = (JType)type.getElementType().accept((GenericVisitor)this, (Object)codeModel);
        for (int index = 0; index < type.getArrayLevel(); ++index) {
            referencedTypeArray = referencedTypeArray.array();
        }
        return referencedTypeArray;
    }

    public JType visit(WildcardType type, JCodeModel codeModel) {
        if (type.getExtendedType().isPresent()) {
            ReferenceType _extends = (ReferenceType)type.getExtendedType().get();
            JType boundType = (JType)_extends.accept((GenericVisitor)this, (Object)codeModel);
            if (!(boundType instanceof JClass)) {
                throw new IllegalArgumentException("Bound type [" + String.valueOf(_extends) + "]in the wildcard type must be class.");
            }
            JClass boundClass = (JClass)boundType;
            return boundClass.wildcard();
        }
        if (type.getSuperType().isPresent()) {
            throw new IllegalArgumentException("Wildcard types with super clause are not supported at the moment.");
        }
        throw new IllegalArgumentException("Wildcard type must have either extends or super clause.");
    }

    public JType visit(ClassOrInterfaceType type, JCodeModel codeModel) {
        String name = this.getName(type);
        JClass knownClass = this.knownClasses.get(name);
        JClass jclass = knownClass != null ? knownClass : codeModel.ref(name);
        List typeArgs = type.getTypeArguments().orElse(null);
        if (typeArgs == null || typeArgs.isEmpty()) {
            return jclass;
        }
        ArrayList<JClass> jtypeArgs = new ArrayList<JClass>(typeArgs.size());
        for (Type typeArg : typeArgs) {
            JType jtype = (JType)typeArg.accept((GenericVisitor)this, (Object)codeModel);
            if (!(jtype instanceof JClass)) {
                throw new IllegalArgumentException("Type argument [" + typeArg.toString() + "] is not a class.");
            }
            jtypeArgs.add((JClass)jtype);
        }
        return jclass.narrow(jtypeArgs);
    }

    private String getName(ClassOrInterfaceType type) {
        String name = type.getNameAsString();
        ClassOrInterfaceType scope = type.getScope().orElse(null);
        if (scope == null) {
            return name;
        }
        return this.getName(scope) + "." + name;
    }
}

