/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.lang;

import java.math.BigDecimal;
import java.util.Objects;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.dom.DOMSource;
import org.custommonkey.xmlunit.Diff;
import org.jvnet.jaxb.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.w3c.dom.Node;

public class ExtendedJAXBEqualsStrategy
extends JAXBEqualsStrategy {
    public static JAXBEqualsStrategy INSTANCE = new ExtendedJAXBEqualsStrategy();

    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, Object lhs, Object rhs) {
        if (lhs instanceof Node && rhs instanceof Node) {
            return this.equalsInternal(leftLocator, rightLocator, (Node)lhs, (Node)rhs);
        }
        if (lhs instanceof XMLGregorianCalendar && rhs instanceof XMLGregorianCalendar) {
            return this.equalsInternal(leftLocator, rightLocator, (XMLGregorianCalendar)lhs, (XMLGregorianCalendar)rhs);
        }
        if (lhs instanceof BigDecimal && rhs instanceof BigDecimal) {
            return this.equalsInternal(leftLocator, rightLocator, (BigDecimal)lhs, (BigDecimal)rhs);
        }
        return super.equalsInternal(leftLocator, rightLocator, lhs, rhs);
    }

    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, XMLGregorianCalendar left, XMLGregorianCalendar right) {
        return this.equals(leftLocator, rightLocator, left.normalize().toGregorianCalendar().getTimeInMillis(), right.normalize().toGregorianCalendar().getTimeInMillis());
    }

    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, BigDecimal left, BigDecimal right) {
        if (Objects.equals(left, right)) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.compareTo(right) == 0;
    }

    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, Node lhs, Node rhs) {
        Diff diff = new Diff(new DOMSource(lhs), new DOMSource(rhs));
        return diff.identical();
    }

    public static JAXBEqualsStrategy getInstance() {
        return INSTANCE;
    }
}

