/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.plugin.codegenerator;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.Validate;
import org.jvnet.jaxb.codemodel.JCMTypeFactory;
import org.jvnet.jaxb.plugin.codegenerator.AbstractCodeGenerator;
import org.jvnet.jaxb.plugin.codegenerator.Arguments;
import org.jvnet.jaxb.plugin.codegenerator.CodeGenerationImplementor;
import org.jvnet.jaxb.plugin.codegenerator.CodeGenerator;

public class JAXBElementCodeGenerator<A extends Arguments<A>>
extends AbstractCodeGenerator<A> {
    private final JCMTypeFactory typeFactory;

    public JAXBElementCodeGenerator(CodeGenerator<A> codeGenerator, CodeGenerationImplementor<A> implementor, JCMTypeFactory typeFactory) {
        super(codeGenerator, implementor);
        this.typeFactory = Validate.notNull(typeFactory);
    }

    private JCMTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public void generate(JBlock block, JType type, Collection<JType> possibleTypes, boolean isAlwaysSet, A arguments) {
        Validate.isInstanceOf(JClass.class, type);
        JClass _class = (JClass)type;
        JClass valueType = this.getValueType(_class);
        Set<JType> possibleValueTypes = this.getPossibleValueTypes(possibleTypes);
        this.onJAXBElement(block, (JType)valueType, possibleValueTypes, isAlwaysSet, arguments);
    }

    private JClass getValueType(JClass _class) {
        List typeParameters = _class.getTypeParameters();
        JClass valueType = typeParameters.size() == 1 ? (JClass)typeParameters.get(0) : this.getCodeModel().ref(Object.class).wildcard();
        return valueType;
    }

    private Set<JType> getPossibleValueTypes(Collection<JType> possibleTypes) {
        HashSet<JType> possibleValueTypes = new HashSet<JType>();
        for (JType possibleType : possibleTypes) {
            Validate.isInstanceOf(JClass.class, possibleType);
            JClass possibleClass = (JClass)possibleType;
            if (possibleClass.getTypeParameters().size() == 1) {
                possibleValueTypes.add((JType)possibleClass.getTypeParameters().get(0));
                continue;
            }
            possibleValueTypes.add((JType)this.getCodeModel().ref(Object.class));
        }
        return possibleValueTypes;
    }

    private void onJAXBElement(JBlock block, JType valueType, Collection<JType> possibleValueTypes, boolean isAlwaysSet, A arguments) {
        block = arguments.ifHasSetValue(block, isAlwaysSet, true);
        this.append(block, "Name", "getName", arguments, (JType)this.getCodeModel().ref(QName.class));
        this.append(block, "Value", "getValue", valueType, possibleValueTypes, arguments);
        this.append(block, "DeclaredType", "getDeclaredType", arguments, (JType)this.getCodeModel().ref(Class.class).narrow(valueType));
        this.append(block, "Scope", "getScope", arguments, (JType)this.getCodeModel().ref(Class.class).narrow(this.getCodeModel().ref(Object.class).wildcard()));
        this.append(block, "Nil", "isNil", arguments, (JType)this.getCodeModel().BOOLEAN);
    }

    private void append(JBlock block, String propertyName, String method, A arguments, JType type) {
        this.append(block, propertyName, method, type, Collections.singleton(type), arguments);
    }

    private void append(JBlock block, String propertyName, String propertyMethod, JType propertyType, Collection<JType> possiblePropertyTypes, A arguments) {
        block = block.block();
        JType declarablePropertyType = this.getTypeFactory().create(propertyType).getDeclarableType();
        boolean isAlwaysSet = propertyType.isPrimitive();
        this.getCodeGenerator().generate(block, propertyType, possiblePropertyTypes, isAlwaysSet, arguments.property(block, propertyName, propertyMethod, declarablePropertyType, declarablePropertyType, possiblePropertyTypes));
    }
}

