/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.maven;

import com.sun.tools.xjc.Options;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.varia.NullAppender;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jvnet.jaxb.maven.XJCMojo;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class Hyperjaxb3Mojo
extends XJCMojo {
    @Parameter(property="maven.hj3.target")
    public File target;
    @Parameter(property="maven.hj3.roundtripTestClassName")
    public String roundtripTestClassName;
    @Parameter
    public String[] resourceIncludes = new String[]{"**/*.hbm.xml", "**/*.orm.xml", "**/*.cfg.xml", "META-INF/persistence.xml"};
    @Parameter(property="maven.hj3.variant", defaultValue="ejb")
    public String variant = "ejb";
    @Parameter(property="maven.hj3.persistenceUnitName")
    public String persistenceUnitName;
    @Parameter(property="maven.hj3.persistenceXml")
    public File persistenceXml;
    @Parameter(property="maven.hj3.generateHashCode", defaultValue="true")
    public boolean generateHashCode = true;
    @Parameter(property="maven.hj3.generateEquals", defaultValue="true")
    public boolean generateEquals = true;
    @Parameter(property="maven.hj3.generateTransientId", defaultValue="false")
    public boolean generateTransientId = false;
    @Parameter(property="maven.hj3.result", defaultValue="annotations")
    public String result = "annotations";
    @Parameter
    public String[] preArgs = new String[0];
    @Parameter
    public String[] postArgs = new String[0];

    protected void setupLogging() {
        super.setupLogging();
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.addAppender((org.apache.log4j.Appender)new NullAppender());
        Logger logger = LogManager.getLogger((String)"org.jvnet.hyperjaxb3");
        Log log = this.getLog();
        logger.addAppender((org.apache.log4j.Appender)new Appender(this.getLog(), (Layout)new PatternLayout("%m%n        %c%n")));
        if (this.getDebug()) {
            log.debug((CharSequence)"Logger level set to [debug].");
            logger.setLevel(Level.DEBUG);
        } else if (this.getVerbose()) {
            logger.setLevel(Level.INFO);
        } else if (log.isWarnEnabled()) {
            logger.setLevel(Level.WARN);
        } else {
            logger.setLevel(Level.ERROR);
        }
    }

    protected void logConfiguration() throws MojoExecutionException {
        super.logConfiguration();
        this.getLog().info((CharSequence)("target:" + this.target));
        this.getLog().info((CharSequence)("roundtripTestClassName:" + this.roundtripTestClassName));
        this.getLog().info((CharSequence)("resourceIncludes:" + this.resourceIncludes));
        this.getLog().info((CharSequence)("variant:" + this.variant));
        this.getLog().info((CharSequence)("persistenceUnitName:" + this.persistenceUnitName));
        this.getLog().info((CharSequence)("persistenceXml:" + this.persistenceXml));
        this.getLog().info((CharSequence)("generateHashCode:" + this.generateHashCode));
        this.getLog().info((CharSequence)("generateEquals:" + this.generateEquals));
        this.getLog().info((CharSequence)("generateTransientId:" + this.generateTransientId));
        this.getLog().info((CharSequence)("result:" + this.result));
        this.getLog().info((CharSequence)("preArgs:" + Arrays.toString(this.preArgs)));
        this.getLog().info((CharSequence)("postArgs:" + Arrays.toString(this.postArgs)));
        try {
            this.getLog().info((CharSequence)("XJC loaded from:" + Options.class.getResource("Options.class").toURI().toURL().toExternalForm()));
        }
        catch (IOException iOException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    protected List<String> getArguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.preArgs != null) {
            arguments.addAll(Arrays.asList(this.preArgs));
        }
        arguments.addAll(super.getArguments());
        if ("ejb".equals(this.variant)) {
            arguments.add("-Xhyperjaxb3-ejb");
            if (this.result != null) {
                arguments.add("-Xhyperjaxb3-ejb-result=" + this.result);
            }
            if (this.roundtripTestClassName != null) {
                arguments.add("-Xhyperjaxb3-ejb-roundtripTestClassName=" + this.roundtripTestClassName);
            }
            if (this.persistenceUnitName != null) {
                arguments.add("-Xhyperjaxb3-ejb-persistenceUnitName=" + this.persistenceUnitName);
            }
            if (this.persistenceXml != null) {
                arguments.add("-Xhyperjaxb3-ejb-persistenceXml=" + this.persistenceXml.getAbsolutePath());
            }
            if (this.generateTransientId) {
                arguments.add("-Xhyperjaxb3-ejb-generateTransientId=true");
            }
        } else if ("jpa3".equals(this.variant)) {
            arguments.add("-Xhyperjaxb3-jpa3");
            if (this.result != null) {
                arguments.add("-Xhyperjaxb3-jpa3-result=" + this.result);
            }
            if (this.roundtripTestClassName != null) {
                arguments.add("-Xhyperjaxb3-jpa3-roundtripTestClassName=" + this.roundtripTestClassName);
            }
            if (this.persistenceUnitName != null) {
                arguments.add("-Xhyperjaxb3-jpa3-persistenceUnitName=" + this.persistenceUnitName);
            }
            if (this.persistenceXml != null) {
                arguments.add("-Xhyperjaxb3-jpa3-persistenceXml=" + this.persistenceXml.getAbsolutePath());
            }
        }
        if (this.generateEquals) {
            arguments.add("-Xequals");
        }
        if (this.generateHashCode) {
            arguments.add("-XhashCode");
        }
        arguments.add("-Xinheritance");
        arguments.add("-Xdefault-value");
        arguments.add("-Xdefault-value:all");
        if (this.postArgs != null) {
            arguments.addAll(Arrays.asList(this.postArgs));
        }
        return arguments;
    }

    protected void setupMavenPaths() {
        super.setupMavenPaths();
        Resource resource = new Resource();
        resource.setDirectory(this.getGenerateDirectory().getPath());
        for (String resourceInclude : this.resourceIncludes) {
            resource.addInclude(resourceInclude);
        }
        this.getProject().addResource(resource);
        if (this.roundtripTestClassName != null) {
            this.getProject().addTestCompileSourceRoot(this.getGenerateDirectory().getPath());
        }
    }

    public static class Appender
    extends AppenderSkeleton {
        private final Log log;
        private final Layout layout;

        public Appender(Log log, Layout layout) {
            this.log = log;
            this.layout = layout;
        }

        public boolean requiresLayout() {
            return true;
        }

        protected void append(LoggingEvent event) {
            if (event.getLevel().equals((Object)Level.TRACE)) {
                this.log.debug((CharSequence)this.layout.format(event));
            } else if (event.getLevel().equals((Object)Level.DEBUG)) {
                this.log.debug((CharSequence)this.layout.format(event));
            } else if (event.getLevel().equals((Object)Level.INFO)) {
                this.log.info((CharSequence)this.layout.format(event));
            } else if (event.getLevel().equals((Object)Level.WARN)) {
                this.log.warn((CharSequence)this.layout.format(event));
            } else if (event.getLevel().equals((Object)Level.ERROR)) {
                this.log.error((CharSequence)this.layout.format(event));
            } else if (event.getLevel().equals((Object)Level.FATAL)) {
                this.log.error((CharSequence)this.layout.format(event));
            }
        }

        public void close() {
        }
    }
}

