/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.xml.bind.annotation.adapters;

import jakarta.xml.bind.DatatypeConverter;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class TimeStringAsCalendar
extends XmlAdapter<String, Calendar> {
    private static final DatatypeFactory datatypeFactory;

    public String marshal(Calendar time) throws Exception {
        if (time == null) {
            return null;
        }
        return DatatypeConverter.printTime((Calendar)time);
    }

    public Calendar unmarshal(String time) throws Exception {
        if (time == null) {
            return null;
        }
        XMLGregorianCalendar xmlGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(time);
        TimeZone timeZone = xmlGregorianCalendar.getTimeZone(0);
        GregorianCalendar calendar = xmlGregorianCalendar.toGregorianCalendar(timeZone, Locale.getDefault(), null);
        return calendar;
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new Error(e);
        }
    }
}

