/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.xsom;

import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.XSXPath;
import com.sun.xml.xsom.XmlString;
import com.sun.xml.xsom.visitor.XSFunction;
import com.sun.xml.xsom.visitor.XSSimpleTypeFunction;
import jakarta.xml.bind.DatatypeConverter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class SimpleTypeAnalyzer {
    public static Long getMinLength(XSComponent component) {
        if (component == null) {
            return null;
        }
        return (Long)component.apply((XSFunction)new MinLengthAnalyzer());
    }

    public static Long getMaxLength(XSComponent component) {
        if (component == null) {
            return null;
        }
        return (Long)component.apply((XSFunction)new MaxLengthAnalyzer());
    }

    public static Long getLength(XSComponent component) {
        if (component == null) {
            return null;
        }
        return (Long)component.apply((XSFunction)new LengthAnalyzer());
    }

    public static Long getTotalDigits(XSComponent component) {
        if (component == null) {
            return null;
        }
        return (Long)component.apply((XSFunction)new TotalDigitsAnalyzer());
    }

    public static Long getFractionDigits(XSComponent component) {
        if (component == null) {
            return null;
        }
        return (Long)component.apply((XSFunction)new FractionDigitsAnalyzer());
    }

    public static class FractionDigitsAnalyzer
    extends AbstractLongFacetAnalyzer {
        @Override
        protected Long aggregateNonNulls(Long currentValue, Long value) {
            return currentValue < value ? currentValue : value;
        }

        @Override
        public Long facet(XSFacet facet) {
            if ("fractionDigits".equals(facet.getName())) {
                return this.getValue(facet);
            }
            return null;
        }
    }

    public static class TotalDigitsAnalyzer
    extends AbstractLongFacetAnalyzer {
        @Override
        protected Long aggregateNonNulls(Long currentValue, Long value) {
            return currentValue < value ? currentValue : value;
        }

        @Override
        public Long facet(XSFacet facet) {
            if ("totalDigits".equals(facet.getName())) {
                return this.getValue(facet);
            }
            return null;
        }
    }

    public static class LengthAnalyzer
    extends AbstractLongFacetAnalyzer {
        @Override
        public Long facet(XSFacet facet) {
            if ("length".equals(facet.getName())) {
                return this.getValue(facet);
            }
            return null;
        }

        @Override
        protected Long aggregateNonNulls(Long currentValue, Long value) {
            return currentValue > value ? currentValue : value;
        }
    }

    public static class MaxLengthAnalyzer
    extends AbstractLongFacetAnalyzer {
        @Override
        public Long facet(XSFacet facet) {
            if ("maxLength".equals(facet.getName())) {
                return this.getValue(facet);
            }
            return null;
        }

        @Override
        protected Long aggregateNonNulls(Long currentValue, Long value) {
            return currentValue < value ? currentValue : value;
        }
    }

    public static class MinLengthAnalyzer
    extends AbstractLongFacetAnalyzer {
        @Override
        public Long facet(XSFacet facet) {
            if ("minLength".equals(facet.getName())) {
                return this.getValue(facet);
            }
            return null;
        }

        @Override
        protected Long aggregateNonNulls(Long currentValue, Long value) {
            return currentValue > value ? currentValue : value;
        }
    }

    public static abstract class AbstractLongFacetAnalyzer
    extends FacetAnalyzer<Long> {
        public Long getValue(XSFacet facet) {
            XmlString value = facet.getValue();
            if (value == null) {
                return null;
            }
            String v = value.value;
            if (v == null) {
                return null;
            }
            BigInteger integerValue = DatatypeConverter.parseInteger((String)v);
            if (integerValue.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                return Long.MAX_VALUE;
            }
            return integerValue.longValue();
        }
    }

    public static abstract class FacetAnalyzer<T>
    implements XSFunction<T>,
    XSSimpleTypeFunction<T> {
        public T annotation(XSAnnotation arg0) {
            return null;
        }

        public T attGroupDecl(XSAttGroupDecl arg0) {
            return null;
        }

        public T attributeDecl(XSAttributeDecl attributeDecl) {
            return (T)attributeDecl.getType().apply((XSSimpleTypeFunction)this);
        }

        public T attributeUse(XSAttributeUse attributeUse) {
            return (T)attributeUse.getDecl().apply((XSFunction)this);
        }

        public T complexType(XSComplexType arg0) {
            return null;
        }

        public T identityConstraint(XSIdentityConstraint arg0) {
            return null;
        }

        public T notation(XSNotation arg0) {
            return null;
        }

        public T schema(XSSchema arg0) {
            return null;
        }

        public T xpath(XSXPath arg0) {
            return null;
        }

        public T empty(XSContentType arg0) {
            return null;
        }

        public T particle(XSParticle particle) {
            return (T)particle.getTerm().apply((XSFunction)this);
        }

        public T simpleType(XSSimpleType simpleType) {
            return (T)simpleType.apply((XSSimpleTypeFunction)this);
        }

        public T restrictionSimpleType(XSRestrictionSimpleType restrictionSimpleType) {
            LinkedList<Object> values = new LinkedList<Object>();
            Object parentValue = restrictionSimpleType.getBaseType() != null ? restrictionSimpleType.getBaseType().apply((XSFunction)this) : null;
            values.add(parentValue);
            for (XSFacet facet : restrictionSimpleType.getDeclaredFacets()) {
                Object facetValue = facet.apply((XSFunction)this);
                values.add(facetValue);
            }
            return (T)this.aggregate(values);
        }

        public T listSimpleType(XSListSimpleType listSimpleType) {
            return (T)listSimpleType.getItemType().apply((XSSimpleTypeFunction)this);
        }

        public T unionSimpleType(XSUnionSimpleType unionSimpleType) {
            ArrayList<Object> values = new ArrayList<Object>(unionSimpleType.getMemberSize());
            for (int index = 0; index < unionSimpleType.getMemberSize(); ++index) {
                values.add(unionSimpleType.getMember(index).apply((XSSimpleTypeFunction)this));
            }
            return (T)this.aggregate(values);
        }

        public T elementDecl(XSElementDecl elementDecl) {
            return (T)elementDecl.getType().apply((XSFunction)this);
        }

        public T modelGroup(XSModelGroup arg0) {
            return null;
        }

        public T modelGroupDecl(XSModelGroupDecl arg0) {
            return null;
        }

        public T wildcard(XSWildcard arg0) {
            return null;
        }

        public T aggregate(Collection<T> values) {
            if (values == null || values.isEmpty()) {
                return null;
            }
            Object currentValue = null;
            for (T value : values) {
                currentValue = this.aggregate(currentValue, value);
            }
            return currentValue;
        }

        protected T aggregate(T currentValue, T value) {
            if (value == null) {
                return currentValue;
            }
            if (currentValue == null) {
                return value;
            }
            return this.aggregateNonNulls(currentValue, value);
        }

        protected abstract T aggregateNonNulls(T var1, T var2);

        public abstract T facet(XSFacet var1);
    }
}

