/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.xjc.model;

import com.sun.tools.xjc.model.CArrayInfo;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CBuiltinLeafInfo;
import com.sun.tools.xjc.model.CClass;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CElement;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.model.CNonElement;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CPropertyVisitor;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.model.CWildcardTypeInfo;
import java.util.Collection;
import java.util.Set;
import org.jvnet.hyperjaxb3.ejb.strategy.model.ProcessModel;
import org.jvnet.hyperjaxb3.xjc.model.CClassifier;

public class CClassifyingVisitor<U>
implements CPropertyVisitor<U> {
    private final ProcessModel context;
    private final CClassifier<U> classifier;

    public CClassifyingVisitor(ProcessModel context, CClassifier<U> classifier) {
        this.context = context;
        this.classifier = classifier;
    }

    public U onAttribute(CAttributePropertyInfo attributePropertyInfo) {
        CNonElement type = this.context.getGetTypes().getTarget(this.context, attributePropertyInfo);
        if (type instanceof CBuiltinLeafInfo) {
            return this.onBuiltinAttribute(attributePropertyInfo);
        }
        if (type instanceof CEnumLeafInfo) {
            return this.onEnumAttribute(attributePropertyInfo);
        }
        return this.onOtherAttribute(attributePropertyInfo);
    }

    public U onValue(CValuePropertyInfo valuePropertyInfo) {
        CNonElement type = this.context.getGetTypes().getTarget(this.context, valuePropertyInfo);
        if (type instanceof CBuiltinLeafInfo) {
            return this.onBuiltinValue(valuePropertyInfo);
        }
        if (type instanceof CEnumLeafInfo) {
            return this.onEnumValue(valuePropertyInfo);
        }
        return this.onOtherValue(valuePropertyInfo);
    }

    public U onElement(CElementPropertyInfo elementPropertyInfo) {
        Collection types = (Collection)this.context.getGetTypes().process(this.context, (CPropertyInfo)elementPropertyInfo);
        if (types.size() == 1) {
            CTypeInfo type = (CTypeInfo)types.iterator().next();
            if (type instanceof CBuiltinLeafInfo) {
                return this.onBuiltinElement(elementPropertyInfo);
            }
            if (type instanceof CEnumLeafInfo) {
                return this.onEnumElement(elementPropertyInfo);
            }
            if (type instanceof CArrayInfo) {
                return this.onArrayElement(elementPropertyInfo);
            }
            if (type instanceof CClass) {
                return this.onClassElement(elementPropertyInfo);
            }
            throw new UnsupportedOperationException("Unexpected type.");
        }
        return this.onHeteroElement(elementPropertyInfo);
    }

    public U onReference(CReferencePropertyInfo referencePropertyInfo) {
        Collection types = (Collection)this.context.getGetTypes().process(this.context, (CPropertyInfo)referencePropertyInfo);
        Set<CElement> elements = this.context.getGetTypes().getElements(this.context, referencePropertyInfo);
        if (types.size() == 1) {
            CTypeInfo type = (CTypeInfo)types.iterator().next();
            if (type instanceof CWildcardTypeInfo || type.equals((Object)CBuiltinLeafInfo.ANYTYPE)) {
                assert (elements.isEmpty());
                assert (referencePropertyInfo.getWildcard() != null);
                assert (!referencePropertyInfo.isMixed());
                return this.onWildcardReference(referencePropertyInfo);
            }
            assert (type instanceof CElement);
            assert (!elements.isEmpty());
            assert (referencePropertyInfo.getWildcard() == null);
            assert (!referencePropertyInfo.isMixed());
            if (type instanceof CClass) {
                return this.onClassReference(referencePropertyInfo);
            }
            if (type instanceof CElementInfo) {
                CElementInfo elementInfo = (CElementInfo)type;
                CNonElement contentType = elementInfo.getContentType();
                if (contentType instanceof CBuiltinLeafInfo) {
                    assert (referencePropertyInfo.getWildcard() == null);
                    assert (referencePropertyInfo.isMixed() ^ elements.isEmpty());
                    return this.onBuiltinElementReference(referencePropertyInfo);
                }
                if (contentType instanceof CEnumLeafInfo) {
                    assert (!elements.isEmpty());
                    assert (referencePropertyInfo.getWildcard() == null);
                    assert (!referencePropertyInfo.isMixed());
                    return this.onEnumElementReference(referencePropertyInfo);
                }
                if (contentType instanceof CArrayInfo) {
                    assert (!elements.isEmpty());
                    assert (referencePropertyInfo.getWildcard() == null);
                    assert (!referencePropertyInfo.isMixed());
                    return this.onArrayElementReference(referencePropertyInfo);
                }
                if (contentType instanceof CClass) {
                    assert (!elements.isEmpty());
                    assert (referencePropertyInfo.getWildcard() == null);
                    assert (!referencePropertyInfo.isMixed());
                    return this.onClassElementReference(referencePropertyInfo);
                }
                throw new UnsupportedOperationException("Unexpected type in property [" + referencePropertyInfo.getName(true) + "] of the class [" + ((CClassInfo)referencePropertyInfo.parent()).getSqueezedName() + "].");
            }
            throw new UnsupportedOperationException("Unexpected type in property [" + referencePropertyInfo.getName(true) + "] of the class [" + ((CClassInfo)referencePropertyInfo.parent()).getSqueezedName() + "].");
        }
        if (referencePropertyInfo.getWildcard() == null && !referencePropertyInfo.isMixed()) {
            if (elements.size() == 1) {
                CElement element = elements.iterator().next();
                if (element instanceof CElementInfo) {
                    return this.onSubstitutedElementReference(referencePropertyInfo);
                }
                throw new UnsupportedOperationException("Unexpected type.");
            }
            return this.onHeteroReference(referencePropertyInfo);
        }
        return this.onHeteroReference(referencePropertyInfo);
    }

    public U onBuiltinAttribute(CAttributePropertyInfo attributePropertyInfo) {
        return !attributePropertyInfo.isCollection() ? this.classifier.onSingleBuiltinAttribute(attributePropertyInfo) : this.classifier.onCollectionBuiltinAttribute(attributePropertyInfo);
    }

    public U onEnumAttribute(CAttributePropertyInfo attributePropertyInfo) {
        return !attributePropertyInfo.isCollection() ? this.classifier.onSingleEnumAttribute(attributePropertyInfo) : this.classifier.onCollectionEnumAttribute(attributePropertyInfo);
    }

    public U onOtherAttribute(CAttributePropertyInfo attributePropertyInfo) {
        return !attributePropertyInfo.isCollection() ? this.classifier.onSingleOtherAttribute(attributePropertyInfo) : this.classifier.onCollectionOtherAttribute(attributePropertyInfo);
    }

    public U onBuiltinValue(CValuePropertyInfo valuePropertyInfo) {
        return !valuePropertyInfo.isCollection() ? this.classifier.onSingleBuiltinValue(valuePropertyInfo) : this.classifier.onCollectionBuiltinValue(valuePropertyInfo);
    }

    public U onEnumValue(CValuePropertyInfo valuePropertyInfo) {
        return !valuePropertyInfo.isCollection() ? this.classifier.onSingleEnumValue(valuePropertyInfo) : this.classifier.onCollectionEnumValue(valuePropertyInfo);
    }

    public U onOtherValue(CValuePropertyInfo valuePropertyInfo) {
        return !valuePropertyInfo.isCollection() ? this.classifier.onSingleOtherValue(valuePropertyInfo) : this.classifier.onCollectionOtherValue(valuePropertyInfo);
    }

    public U onBuiltinElement(CElementPropertyInfo elementPropertyInfo) {
        return !elementPropertyInfo.isCollection() ? this.classifier.onSingleBuiltinElement(elementPropertyInfo) : this.classifier.onCollectionBuiltinElement(elementPropertyInfo);
    }

    public U onEnumElement(CElementPropertyInfo elementPropertyInfo) {
        return !elementPropertyInfo.isCollection() ? this.classifier.onSingleEnumElement(elementPropertyInfo) : this.classifier.onCollectionEnumElement(elementPropertyInfo);
    }

    public U onArrayElement(CElementPropertyInfo elementPropertyInfo) {
        return !elementPropertyInfo.isCollection() ? this.classifier.onSingleArrayElement(elementPropertyInfo) : this.classifier.onCollectionArrayElement(elementPropertyInfo);
    }

    public U onClassElement(CElementPropertyInfo elementPropertyInfo) {
        return !elementPropertyInfo.isCollection() ? this.classifier.onSingleClassElement(elementPropertyInfo) : this.classifier.onCollectionClassElement(elementPropertyInfo);
    }

    public U onHeteroElement(CElementPropertyInfo elementPropertyInfo) {
        return !elementPropertyInfo.isCollection() ? this.classifier.onSingleHeteroElement(elementPropertyInfo) : this.classifier.onCollectionHeteroElement(elementPropertyInfo);
    }

    public U onBuiltinElementReference(CReferencePropertyInfo referencePropertyInfo) {
        return !referencePropertyInfo.isCollection() ? this.classifier.onSingleBuiltinElementReference(referencePropertyInfo) : this.classifier.onCollectionBuiltinElementReference(referencePropertyInfo);
    }

    public U onEnumElementReference(CReferencePropertyInfo referencePropertyInfo) {
        return !referencePropertyInfo.isCollection() ? this.classifier.onSingleEnumElementReference(referencePropertyInfo) : this.classifier.onCollectionEnumElementReference(referencePropertyInfo);
    }

    public U onArrayElementReference(CReferencePropertyInfo referencePropertyInfo) {
        return !referencePropertyInfo.isCollection() ? this.classifier.onSingleArrayElementReference(referencePropertyInfo) : this.classifier.onCollectionArrayElementReference(referencePropertyInfo);
    }

    public U onClassElementReference(CReferencePropertyInfo referencePropertyInfo) {
        return !referencePropertyInfo.isCollection() ? this.classifier.onSingleClassElementReference(referencePropertyInfo) : this.classifier.onCollectionClassElementReference(referencePropertyInfo);
    }

    public U onSubstitutedElementReference(CReferencePropertyInfo referencePropertyInfo) {
        return !referencePropertyInfo.isCollection() ? this.classifier.onSingleSubstitutedElementReference(referencePropertyInfo) : this.classifier.onCollectionSubstitutedElementReference(referencePropertyInfo);
    }

    public U onClassReference(CReferencePropertyInfo referencePropertyInfo) {
        return !referencePropertyInfo.isCollection() ? this.classifier.onSingleClassReference(referencePropertyInfo) : this.classifier.onCollectionClassReference(referencePropertyInfo);
    }

    public U onWildcardReference(CReferencePropertyInfo referencePropertyInfo) {
        return !referencePropertyInfo.isCollection() ? this.classifier.onSingleWildcardReference(referencePropertyInfo) : this.classifier.onCollectionWildcardReference(referencePropertyInfo);
    }

    public U onHeteroReference(CReferencePropertyInfo referencePropertyInfo) {
        return !referencePropertyInfo.isCollection() ? this.classifier.onSingleHeteroReference(referencePropertyInfo) : this.classifier.onCollectionHeteroReference(referencePropertyInfo);
    }
}

