/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.strategy.mapping;

import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.java.xml.ns.persistence.orm.Attributes;
import com.sun.java.xml.ns.persistence.orm.Basic;
import com.sun.java.xml.ns.persistence.orm.ElementCollection;
import com.sun.java.xml.ns.persistence.orm.Embedded;
import com.sun.java.xml.ns.persistence.orm.EmbeddedId;
import com.sun.java.xml.ns.persistence.orm.Id;
import com.sun.java.xml.ns.persistence.orm.ManyToMany;
import com.sun.java.xml.ns.persistence.orm.ManyToOne;
import com.sun.java.xml.ns.persistence.orm.OneToMany;
import com.sun.java.xml.ns.persistence.orm.OneToOne;
import com.sun.java.xml.ns.persistence.orm.Transient;
import com.sun.java.xml.ns.persistence.orm.Version;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CClass;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.hyperjaxb3.codemodel.util.JTypeUtils;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Customizations;
import org.jvnet.hyperjaxb3.ejb.strategy.mapping.ClassOutlineMapping;
import org.jvnet.hyperjaxb3.ejb.strategy.mapping.FieldOutlineMapping;
import org.jvnet.hyperjaxb3.ejb.strategy.mapping.Mapping;
import org.jvnet.hyperjaxb3.xjc.model.CTypeInfoUtils;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;
import org.jvnet.jaxb2_commons.util.FieldAccessorUtils;

public class AttributesMapping
implements ClassOutlineMapping<Attributes> {
    protected Log logger = LogFactory.getLog(this.getClass());

    @Override
    public Attributes process(Mapping context, ClassOutline classOutline, Options options) {
        FieldOutline[] fieldOutlines;
        Attributes attributes = new Attributes();
        for (FieldOutline fieldOutline : fieldOutlines = classOutline.getDeclaredFields()) {
            Object attributeMapping = this.getAttributeMapping(context, fieldOutline, options).process(context, fieldOutline, options);
            if (attributeMapping instanceof Id) {
                if (attributes.getEmbeddedId() == null) {
                    attributes.getId().add((Id)attributeMapping);
                    continue;
                }
                this.logger.error((Object)("Could not add an id element to the attributes of the class [" + fieldOutline.parent().target.getName() + "] because they already contain an embedded-id element."));
                continue;
            }
            if (attributeMapping instanceof EmbeddedId) {
                if (!attributes.getId().isEmpty()) {
                    this.logger.error((Object)("Could not add an embedded-id element to the attributes of the class [" + fieldOutline.parent().target.getName() + "] because they already contain an id element."));
                    continue;
                }
                if (attributes.getEmbeddedId() != null) {
                    this.logger.error((Object)("Could not add an embedded-id element to the attributes of the class [" + fieldOutline.parent().target.getName() + "] because they already contain an embedded-id element."));
                    continue;
                }
                attributes.setEmbeddedId((EmbeddedId)attributeMapping);
                continue;
            }
            if (attributeMapping instanceof Basic) {
                attributes.getBasic().add((Basic)attributeMapping);
                continue;
            }
            if (attributeMapping instanceof Version) {
                attributes.getVersion().add((Version)attributeMapping);
                continue;
            }
            if (attributeMapping instanceof ManyToOne) {
                attributes.getManyToOne().add((ManyToOne)attributeMapping);
                continue;
            }
            if (attributeMapping instanceof OneToMany) {
                attributes.getOneToMany().add((OneToMany)attributeMapping);
                continue;
            }
            if (attributeMapping instanceof OneToOne) {
                attributes.getOneToOne().add((OneToOne)attributeMapping);
                continue;
            }
            if (attributeMapping instanceof ManyToMany) {
                attributes.getManyToMany().add((ManyToMany)attributeMapping);
                continue;
            }
            if (attributeMapping instanceof ElementCollection) {
                attributes.getElementCollection().add((ElementCollection)attributeMapping);
                continue;
            }
            if (attributeMapping instanceof Embedded) {
                attributes.getEmbedded().add((Embedded)attributeMapping);
                continue;
            }
            if (!(attributeMapping instanceof Transient)) continue;
            attributes.getTransient().add((Transient)attributeMapping);
        }
        return attributes;
    }

    public FieldOutlineMapping<?> getAttributeMapping(Mapping context, FieldOutline fieldOutline, Options options) {
        if (context.getIgnoring().isFieldOutlineIgnored(context, fieldOutline)) {
            return context.getTransientMapping();
        }
        if (this.isFieldOutlineId(fieldOutline)) {
            return context.getIdMapping();
        }
        if (this.isFieldOutlineVersion(fieldOutline)) {
            return context.getVersionMapping();
        }
        CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
        if (!propertyInfo.isCollection()) {
            this.logger.trace((Object)("Field outline  [" + propertyInfo.getName(true) + "] is a single field."));
            Collection types = (Collection)context.getGetTypes().process(context, propertyInfo);
            if (types.size() == 1) {
                this.logger.trace((Object)("Field outline  [" + propertyInfo.getName(true) + "] is a homogeneous single field."));
                if (this.isFieldOutlineBasic(context, fieldOutline)) {
                    return context.getBasicMapping();
                }
                if (this.isFieldOutlineComplex(context, fieldOutline)) {
                    this.logger.trace((Object)("Field outline  [" + propertyInfo.getName(true) + "] is a complex field."));
                    if (this.isFieldOutlineEmbeddedId(context, fieldOutline)) {
                        this.logger.trace((Object)("Field outline  [" + propertyInfo.getName(true) + "] is an embedded-id complex field."));
                        return context.getEmbeddedIdMapping();
                    }
                    if (this.isFieldOutlineEmbedded(context, fieldOutline)) {
                        this.logger.trace((Object)("Field outline  [" + propertyInfo.getName(true) + "] is an embedded complex field."));
                        return context.getEmbeddedMapping();
                    }
                    return context.getToOneMapping();
                }
            } else {
                this.logger.warn((Object)("Field outline  [" + propertyInfo.getName(true) + "] is a heterogeneous single field."));
            }
        } else {
            this.logger.trace((Object)("Field outline [" + propertyInfo.getName(true) + "] is a collection field."));
            if (this.isFieldOutlineSingletypedHomogeneous(context, fieldOutline)) {
                this.logger.debug((Object)("Field outline  [" + propertyInfo.getName(true) + "] is a homogeneous collection field."));
                if (this.isFieldOutlineElementCollection(context, fieldOutline)) {
                    return context.getElementCollectionMapping();
                }
                if (this.isFieldOutlineComplex(context, fieldOutline)) {
                    this.logger.debug((Object)("Field outline  [" + propertyInfo.getName(true) + "] is a complex homogeneous collection field."));
                    return context.getToManyMapping();
                }
            } else if (this.isFieldOutlineMultitypedHomogeneous(context, fieldOutline)) {
                this.logger.debug((Object)("Field outline  [" + propertyInfo.getName(true) + "] is a multityped homogeneous collection field."));
                if (this.isFieldOutlineComplex(context, fieldOutline)) {
                    this.logger.debug((Object)("Field outline  [" + propertyInfo.getName(true) + "] is a complex multityped homogeneous collection field."));
                    return context.getToManyMapping();
                }
            } else {
                this.logger.warn((Object)("Field outline  [" + propertyInfo.getName(true) + "] is a heterogenous collection field."));
            }
        }
        this.logger.error((Object)("Field outline  [" + ((CClassInfo)propertyInfo.parent()).getName() + "." + propertyInfo.getName(true) + "] could not be annotated. It will be made transient."));
        return context.getTransientMapping();
    }

    public boolean isFieldOutlineId(FieldOutline fieldOutline) {
        return CustomizationUtils.containsCustomization((FieldOutline)fieldOutline, (QName)Customizations.ID_ELEMENT_NAME);
    }

    public boolean isFieldOutlineVersion(FieldOutline fieldOutline) {
        return CustomizationUtils.containsCustomization((FieldOutline)fieldOutline, (QName)Customizations.VERSION_ELEMENT_NAME);
    }

    public boolean isFieldOutlineBasic(Mapping context, FieldOutline fieldOutline) {
        return this.isFieldOutlineCore(context, fieldOutline) || this.isFieldOutlineEnumerated(context, fieldOutline);
    }

    public boolean isFieldOutlineCore(Mapping context, FieldOutline fieldOutline) {
        JMethod getter = FieldAccessorUtils.getter((FieldOutline)fieldOutline);
        JType type = getter.type();
        return JTypeUtils.isBasicType(type);
    }

    public boolean isFieldOutlineEnumerated(Mapping context, FieldOutline fieldOutline) {
        CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
        Collection types = (Collection)context.getGetTypes().process(context, propertyInfo);
        if (types.size() == 1) {
            CTypeInfo type = (CTypeInfo)types.iterator().next();
            return type instanceof CEnumLeafInfo;
        }
        return false;
    }

    public boolean isFieldOutlineSingletypedHomogeneous(Mapping context, FieldOutline fieldOutline) {
        Collection types = (Collection)context.getGetTypes().process(context, fieldOutline.getPropertyInfo());
        return types.size() == 1;
    }

    public boolean isFieldOutlineMultitypedHomogeneous(Mapping context, FieldOutline fieldOutline) {
        return this.getCommonBaseTypeInfo(context, fieldOutline) != null;
    }

    public CTypeInfo getCommonBaseTypeInfo(Mapping context, FieldOutline fieldOutline) {
        CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
        Collection types = (Collection)context.getGetTypes().process(context, propertyInfo);
        return CTypeInfoUtils.getCommonBaseTypeInfo(types);
    }

    public boolean isFieldOutlineElementCollection(Mapping context, FieldOutline fieldOutline) {
        return this.isFieldOutlineCore2(context, fieldOutline) || this.isFieldOutlineEnumerated(context, fieldOutline);
    }

    public boolean isFieldOutlineCore2(Mapping context, FieldOutline fieldOutline) {
        CTypeInfo type = this.getCommonBaseTypeInfo(context, fieldOutline);
        assert (type != null);
        return JTypeUtils.isBasicType(type.toType(fieldOutline.parent().parent(), Aspect.EXPOSED));
    }

    public boolean isFieldOutlineComplex(Mapping context, FieldOutline fieldOutline) {
        CTypeInfo type = this.getCommonBaseTypeInfo(context, fieldOutline);
        assert (type != null);
        return type instanceof CClass;
    }

    public boolean isFieldOutlineEmbedded(Mapping context, FieldOutline fieldOutline) {
        CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
        Collection types = (Collection)context.getGetTypes().process(context, propertyInfo);
        assert (types.size() == 1);
        CTypeInfo type = (CTypeInfo)types.iterator().next();
        return type instanceof CClass && CustomizationUtils.containsCustomization((FieldOutline)fieldOutline, (QName)Customizations.EMBEDDED_ELEMENT_NAME) || type instanceof CClassInfo && CustomizationUtils.containsCustomization((CClassInfo)((CClassInfo)type), (QName)Customizations.EMBEDDABLE_ELEMENT_NAME);
    }

    public boolean isFieldOutlineEmbeddedId(Mapping context, FieldOutline fieldOutline) {
        Collection types = (Collection)context.getGetTypes().process(context, fieldOutline.getPropertyInfo());
        assert (types.size() == 1);
        CTypeInfo type = (CTypeInfo)types.iterator().next();
        return type instanceof CClass && CustomizationUtils.containsCustomization((FieldOutline)fieldOutline, (QName)Customizations.EMBEDDED_ID_ELEMENT_NAME);
    }
}

