/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.reactor;

import java.util.Collection;
import org.jvnet.hudson.reactor.Milestone;
import org.jvnet.hudson.reactor.Task;

public interface ReactorListener {
    public static final ReactorListener NOOP = new ReactorListener(){

        public void onTaskStarted(Task t) {
        }

        public void onTaskCompleted(Task t) {
        }

        public void onTaskFailed(Task t, Throwable err, boolean fatal) {
        }

        public void onAttained(Milestone milestone) {
        }
    };

    public void onTaskStarted(Task var1);

    public void onTaskCompleted(Task var1);

    public void onTaskFailed(Task var1, Throwable var2, boolean var3);

    public void onAttained(Milestone var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Aggregator
    implements ReactorListener {
        private final Collection<ReactorListener> listeners;

        public Aggregator(Collection<ReactorListener> listeners) {
            this.listeners = listeners;
        }

        @Override
        public void onTaskStarted(Task t) {
            for (ReactorListener listener : this.listeners) {
                listener.onTaskStarted(t);
            }
        }

        @Override
        public void onTaskCompleted(Task t) {
            for (ReactorListener listener : this.listeners) {
                listener.onTaskCompleted(t);
            }
        }

        @Override
        public void onTaskFailed(Task t, Throwable err, boolean fatal) {
            for (ReactorListener listener : this.listeners) {
                listener.onTaskFailed(t, err, fatal);
            }
        }

        @Override
        public void onAttained(Milestone milestone) {
            for (ReactorListener listener : this.listeners) {
                listener.onAttained(milestone);
            }
        }
    }
}

